#include "mex.h"
#include "math.h"

#define	IN	prhs[0]
#define	SHEER	prhs[1]
#define MINMAX  prhs[2]
#define IMSIZE  prhs[3]
#define	M	plhs[0]
#define	T	plhs[1]
#define	B	plhs[2]
#define	L	plhs[3]
#define	R	plhs[4]

#define min(x,y) (((x)<(y)) ? (x) : (y))
#define max(x,y) (((x)>(y)) ? (x) : (y))

void wtasums(double s[],int I,int J, double sheer[], 
  int mini, int maxi, int minj, int maxj,
  double *m, double *t,double *b,double *l,double *r, double *imsize)
{
 int i1,i2,j1,j2,is[1024];
 int nw,ne,sw,se;
 double v;
 *m = -mxGetInf();

 for(i1=0; i1<I-1; i1++) { is[i1] = (int)sheer[i1]; }

 for(i1=0 ; i1<I ; i1++) {
  for(i2=i1+mini ; i2<min(I,i1+maxi) ; i2++) {
   for(j1=is[i2-1] ; j1<J-is[I-i1-2] ; j1++) {
    for(j2=j1+minj ; j2<min(J-is[I-i1-2],j1+maxj) ; j2++) {
     nw = i1 + j1 * I ;
     ne = i1 + j2 * I ;
     sw = i2 + j1 * I ;
     se = i2 + j2 * I ;
     v = (*(s+se)-*(s+sw)-*(s+ne)+*(s+nw))/((i2-i1)*(j2-j1))
         /(1+exp(-5.0*max(i2-i1,j2-j1)/((int)*imsize)));
     if (*m<v) { 
      *m=v; 
      *t = i1; *b = i2; *l = j1; *r = j2; 
     } 
    }
   }
  }
 }
}

void mexFunction( int nlhs, mxArray *plhs[], 
		  int nrhs, const mxArray*prhs[] )
     
{ 
    if (nrhs != 4) { 
	mexErrMsgTxt("Four input arguments required."); 
    } else if (nlhs != 5) {
	mexErrMsgTxt("Five output arguments required."); 
    } else if (!mxIsDouble(IN) || mxIsComplex(IN) || 
	(mxGetNumberOfDimensions(IN) > 2)) { 
	mexErrMsgTxt("wtasums expects a real double matrix."); 
    }
    M = mxCreateDoubleMatrix(1,1,mxREAL);
    T = mxCreateDoubleMatrix(1,1,mxREAL);
    B = mxCreateDoubleMatrix(1,1,mxREAL);
    L = mxCreateDoubleMatrix(1,1,mxREAL);
    R = mxCreateDoubleMatrix(1,1,mxREAL);

    /* Do the actual computations in a subroutine */
    wtasums(mxGetPr(IN), mxGetM(IN), mxGetN(IN), mxGetPr(SHEER),
     mxGetPr(MINMAX)[0], mxGetPr(MINMAX)[1], 
     mxGetPr(MINMAX)[2], mxGetPr(MINMAX)[3],
     mxGetPr(M), mxGetPr(T), mxGetPr(B), mxGetPr(L), mxGetPr(R), 
     mxGetPr(IMSIZE));  
}


