% TRYBUILDING
%
% This script produces the outputs used in the report on the image of a 
% building.

% Reads image and resize.
im=imread('images/building.jpg');
im=imresize(im,[256 256]);

% Computes edge responses.
res = edges(im,[0 30 45 60 90 120 135 150]);

% Sets up the pyramid
H = setuppyramid(res,[0 30 45 60 90 120 135 150],[256 100 30],[256 100 30],[5 5],[5 5],[5 5 5],[5 5 5],[256 100 30],[256 100 30]);

% Shows the pyramid
showpyramid(H);
pause

% Determines first fovea.
H = attend(H);
showpyramid(H);
pause

% Determines next 15 foveas by inhibiting then attending.
for ii=1:15,
 H = attend(inhibit(H));
 showpyramid(H);
 pause
end;

% Prints the images used in the report.
printfovea(im,res,H,16,'eps/building');
