function [i,j] = tblr2coord(t,b,l,r,sheer,I,sheerflipud,sheertranspose);

% FUNCTION [i,j] = TBLR2COORD(t,b,l,r,sheer,I,sheerflipud,sheertranspose);
%
% Converts a representation of a receptive field (t,b,l,r) to a sequence of
% five coordinates given by (i(k),j(k)) for k=1,2,3,4,5, so that
% the plot(i,j) command will draw the RF correctly in an image of the layer.

i = [t+.5 t+.5 b+.5 b+.5 t+.5];
j = [l+.5 r+.5 r+sheer(t+1)-sheer(b+1)+.5 l+sheer(t+1)-sheer(b+1)+.5 l+.5];

if sheertranspose, tmp=i; i=j; j=tmp; end;
if sheerflipud, i=I-i+1; end;
