function showpyramid(H);

% FUNCTION SHOWPYRAMID(H);
%
% Displays the pyramid and the attention beam.  The layers of the pyramid
% are in black and white, with brighter intensity meaning larger response.
% The beam is drawn as a receptive field (sheered rectangles) for each layer.
% The receptive fields are all yellow in color, except for the winning RF,
% which is red.

% Determines the maximum response in the whole pyramid to normalize the
% intensities of responses.
m=0;
for f=1:H.F,
 for l=1:H.L,
  m = max(m,max(H.D{l,f}(:)));
 end;
end;

% deltaI, deltaJ are the separations between layers drawn on the screen.
deltaI = .1/(H.L+1);
deltaJ = .1/(H.F+1);

% total number of rows over the layers.
sumi = sum(H.layerI);

x  = deltaJ;
dx = .9/H.F;
for f=1:H.F,		% for each edge feature,
 y  = deltaI;
 for l=1:H.L,		% for each layer,
  dy = .9*H.layerI(l)/sumi;

  % draw the layer
  subplot('position',[x y dx dy]);
  imshow(H.D{l,f},[0 m]);

  % if an attention beam exists, draw it.
  if H.beam{1,1}.v>-Inf,
   hold on;
   [i j]=tblr2coord(H.beam{l,f}.t,H.beam{l,f}.b,H.beam{l,f}.l,H.beam{l,f}.r,...
       H.sheer{l,f}, H.layerI(l), H.sheerflipud(f), H.sheertranspose(f));
   if (l==1) & ~isempty(H.fovea),
    if f==H.fovea{end}.f,
     % if the current RF is the fovea, draw it in red.
     plot(j,i,'r');
    else
     plot(j,i,'y');
    end;
   else
    plot(j,i,'y');
   end;

   hold off;
  end;
  y = y+dy+deltaI;
 end;
 x = x+dx+deltaJ;
end;
