function H = sheersums(H);

% FUNCTION H = SHEERSUMS(H);
% 
% Computes top-left quadrant sums for each layer in the pyramid.
% Sheer the layers if receptive fields are not rectangular (are parallelogram).

for f=1:H.F,
 for l=1:H.L,
  if H.sheerflipud(f), 
   tmp = flipud(H.D{l,f}); 
  else 
   tmp = H.D{l,f}; 
  end;
  if H.sheertranspose(f), 
   tmp = tmp'; 
  end;
  H.S{l,f} = zeros(H.sheerI(l,f),H.sheerJ(l,f));
  for i=1:H.sheerI(l,f),
   H.S{l,f}(i+1,(1:H.layerJ(l))+H.sheer{l,f}(i)+1) = tmp(i,:);
  end;
  H.S{l,f} = cumsum(cumsum(H.S{l,f},1),2);
 end;
end;
