function printfovea(im, res, H, len, filename);

% FUNCTION PRINTFOVEA(im, res, H, len, filename);
%
% A function to print out the image, the edge responses, and the sequence of
% first len foveas to encapsulated postscript files.  The foveas are drawn
% as in the report.
%
% The files produced are :
%  filename.eps		- image
%  filename-edges.eps	- edge responses
%  filename-rf<n>.eps	- the first to n'th fovea

clf
imshow(im);
print('-deps',[filename '.eps']);

im = sum(abs(res),3);
im = 1-im/max(im(:));
imshow(im,[0 1]);
print('-deps',[filename '-edges.eps']);

im = ones(size(im)); im(1,:)=0; im(end,:)=0; im(:,1)=0; im(:,end)=0;
imshow(im,[0 1]);
hold on;

fovea = H.fovea;
for fi=1:len,
 [i j]=tblr2coord(fovea{fi}.t,fovea{fi}.b,fovea{fi}.l,fovea{fi}.r,...
       H.sheer{1,fovea{fi}.f}, H.layerI(1), ...
       H.sheerflipud(fovea{fi}.f), H.sheertranspose(fovea{fi}.f));
 color = [1 0 0]*(len-fi)/(len-1)+[0 0 1]*(fi-1)/(len-1);
 plot(j,i,'color',color);
 print('-deps',[filename '-rf' num2str(fi) '.eps']);
end;

