function H = inhibit(H);

% FUNCTION H = INHIBIT(H);
%
% If a fovea exists, inhibit the responses in the fovea by setting to zero.
% Then uppropagates the responses through the pyramid again.

if ~isempty(H.fovea),
 rf = H.fovea{end};
 for f=1:H.F,
  if H.sheerflipud(rf.f), 
   tmp = flipud(H.D{1,f}); 
  else 
   tmp = H.D{1,f}; 
  end;
  if H.sheertranspose(rf.f), 
   tmp = tmp'; 
  end;
  for i=rf.t+1:rf.b,
   s = H.sheer{1,rf.f}(i)-H.sheer{1,rf.f}(rf.t+1);
   tmp(i,rf.l-s+1:rf.r-s) = 0;
  end;
  if H.sheertranspose(rf.f),
   tmp = tmp';
  end;
  if H.sheerflipud(rf.f),
   H.D{1,f} = flipud(tmp);
  else
   H.D{1,f} = tmp;
  end;
 end;
end; 
H = uppropagate(H);
