function H = attend(H);
%
% FUNCTION H = ATTEND(H);
%
% Computes an attention beam and selects winning RF to be fovea.

H = sheersums(H);

mv = -Inf;
for f = 1:H.F,
 % For each edge feature, start at the top layer
 T = 0; B = H.sheerI(H.L,f);
 L = 0; R = H.sheerJ(H.L,f);

 for l = H.L:-1:1,
  % For each layer starting at the top, gets the region over which we perform
  % WTA to select winning RF in the layer.
  sheer = H.sheer{l,f}(T+1:B-1)-H.sheer{l,f}(T+1); 
  if l<H.L, sheer = zeros(size(sheer)); end;

  % Selects winning RF.
  [fv ft fb fl fr] = ...
   wtasums(H.S{l,f}(T+1:B,L+1:R), sheer, ...
           [H.minI(l) H.maxI(l) H.minJ(l) H.maxJ(l)],...
           sqrt(H.layerI(l)*H.layerJ(l)));

  % If the current layer is not the bottom-most layer, determine the
  % inputs in the layer below to the winning RF.
  [ft fb fl fr] = tblrS2D(...
   T+ft, T+fb, L+fl, L+fr, H.sheer{l,f});
  if l>1, 
   [T B L R] = tblrdown(ft, fb, fl, fr,...
     H.skipI(l-1), H.skipJ(l-1), H.filtI(l-1), H.filtJ(l-1),...
     H.sheertranspose(f));
   [T B L R] = tblrD2S(T,B,L,R,H.sheer{l-1,f});
  end;

  H.beam{l,f} = struct('v',fv,'t',ft,'b',fb,'l',fl,'r',fr);
 end;

 % Selects overall winning RF to be the fovea.
 if mv<fv,
  mv = fv; mf = f; mt = ft; mb = fb; ml = fl; mr = fr;
 end;
end;

H.fovea{end+1} = struct('f',mf,'v',mv,'t',mt,'b',mb,'l',ml,'r',mr);
