% This is an implementation of the attention mechanism of Tsotsos et al in
% the case of edge features.
% 
% The functions the user is concerned with are :
% 
%  edges	- computes edge feature maps from images
%  setuppyramid	- sets up the various variables and parameters related to the
% 		  pyramids.
%  attend	- computes the most salient RF to be the fovea.
%  inhibit	- inhibit the responses in the fovea.
%  showpyramid	- displays the pyramids and the attention beams and fovea.
%  printfovea	- prints out various images in encapsulated postscript 
% 		  for outputs as in the report.
% 
% The helper functions are :
% 
%  uppropagate	- propagates the responses up the pyramid through averaging
% 		  filters.
%  sheersums	- sheers the feature maps so that RFs become rectangular
% 		  and computes top-left quadrant sums for the sheered maps.
%  wtasums	- given a region of a feature map determine the most salient
% 		  RF in the region.
%  trybuilding	- a sample run demonstrating how to use the various functions.
%  tblr*	- functions converting from a representation of RFs to another
% 		  representation of the same RF, or from one RF to another.
% 
% Representations of RFs :
% 
% Each feature map of each pyramid is a rectangular array of numbers.  We call
% this the O-map, as they are the original untransformed feature maps.  In the 
% O-map each RF is a sheered rectangle (figure 3.1 of report).  The O-map is
% perhaps flipped vertically and perhaps transposed so that all the RFs are
% shaped as in follows :
% 			   *********
% 			  *********
% 			 *********
% 			*********
%  
% We call this flipped and transposed map the D-map.  Now to make the RFs 
% rectangular for easier computations, the D-maps are sheered.  The sheered 
% D-maps are called the S-maps.
% 
% There are 3 representations of RFs involved : representing the RFs in the
% D-maps, in the S-maps, and as lists of (x,y) coordinates to be used in
% drawing the RFs.
% 
% A RF in the D-map is represented by 4 numbers : t, b, l and r.
%         l|     r
%   t      |     |
%   -------*******	t+1 is the number of the top row of the RF
%         *******	b   is the number of the bottom row of the RF
%        *******	l+1 is the number of the column of the top left element
%       *******		    of the RF
%   b--*******	 	r   is the number of the column of the top right 
% 			    element of the RF.
% 
% A RF in the S-map is represented by 4 numbers also : t, b, l and r.
%       l|     r
%   t    |     |
%   -----******* 	t+1 is the number of the top row of the RF
%        ******* 	b   is the number of the bottom row of the RF
%        ******* 	l+1 is the number of the left most column of the RF
%        ******* 	r   is the number of the right most colume of the RF
%   b----******* 

