\name{multiSiena-package}
\alias{multiSiena-package}
\alias{multiSiena}
\docType{package}
\title{
Simulation Investigation for Multilevel Empirical Network Analysis
}
\description{

Package \code{multiSiena} is based on \code{\link{RSiena}}, and has the
extra functionality of function \code{\link{sienaBayes}}.
}
\details{This package is a multilevel extension of the \code{\link{RSiena}} package for
   simulation-based estimation of stochastic actor-oriented models for
   longitudinal network data collected as panel data.
   The extension consists of the function sienaBayes and associated functions.
   The purpose is to fit hierarchical Bayesian models random effects
   to \code{sienaGroup} data objects.
   
   It was built on RSiena 1.5.6.

  Next to the help pages, more detailed help is available in the manual
  (see below) and a lot of information is at the website (also see below).

  \tabular{ll}{
    Package: \tab multiSiena\cr
    Type: \tab Package\cr
    Version: \tab 1.2.35\cr
    Date: \tab 2025-10-30\cr
    Depends: \tab R (>= 3.5.0), RSiena (>= 1.5.2)\cr
    Imports: \tab Matrix, parallel, MASS, methods\cr
    Suggests: \tab codetools\cr
    SystemRequirements: \tab GNU make\cr
    License:  \tab GPL-3\cr
    LazyData:  \tab yes\cr
    BuildResaveData:  \tab no\cr
    NeedsCompilation: \tab yes\cr
  }
}
\author{
  Ruth Ripley, Tom Snijders, Johan Koskinen.

  Maintainer: Tom A.B. Snijders <tom.snijders@nuffield.ox.ac.uk>
}
\references{See \url{http://www.stats.ox.ac.uk/~snijders/siena/}

  Koskinen, J.H. and T.A.B. Snijders (2007).
  Bayesian inference for dynamic social network data.
  \emph{Journal of Statistical Planning and Inference}, 13, 3930-3938.

  Koskinen, J.H. and T.A.B. Snijders (2023).
  Multilevel Longitudinal Analysis of Social Networks.
  Journal of the Royal Statistical Society, Series A, 186, 376-400, 
  DOI: https://doi.org/10.1093/jrsssa/qnac009 
}
\seealso{\code{\link{RSiena}}, \code{\link{sienaBayes}}}
\keyword{ package }
