##/*****************************************************************************
## * SIENA: Simulation Investigation for Empirical Network Analysis
## *
## * Web: https://www.stats.ox.ac.uk/~snijders/siena
## *
## * File: multiGOF.r
## *
## * Description: This file contains the code to run forward simulations.
## * for sienaBayesFit objects.
## *
## ****************************************************************************/

simulateData <- function(g, x, xd, thin=1, nstart=x$nwarm,
                                            seed=NULL, nbrNodes=1){
# g is group number
# x is a sienaBayesFit object
# xd the corresponding multigroup data set.
# This function takes groupwise simulated parameter values from x for group g
# and simulates group g in xd for these parameters.
# Output is the sienaFit object ans with simulated data,
# to which the number of actors is added as ans$nact.
    if (g > length(xd))
    {
        stop('g larger than number of groups in xd')
    }
    if (g > dim(x$ThinParameters)[2])
    {
        stop('g larger than number of groups in x')
    }
    cat('+')
    if ((g %% 10)==0){
        cat(g,'\n')
    }
    flush.console()
    xd1 <- xd[[g]]
# Project the effects in x down to xd1.
    effs1 <- getEffects(xd1)
    reff <- x$requestedEffects
    reff[reff$groupName == reff$groupName[1], 'groupName'] <- effs1$groupName[1]
    effs1 <- updateSpecification(effs1, reff, x$effects)
    nm <-  sum(!is.na(x$ThinParameters[,1,1])) - nstart
    nmt <- nm %/% thin # integer division
#   npar <- dim(x$ThinParameters)[3]
# Construct matrix of parameter values for simulations
    thetaValues0.g <- x$ThinParameters[nstart + (1:nmt)*thin,g,]
    thetaValues.g <- thetaValues0.g
	sink("temp.txt") # needed since silent=TRUE is not yet in operation 1.4.9
    simalg <- sienaAlgorithmCreate(projname=NULL, nsub=0, n3=nmt,
                            cond=FALSE, simOnly=TRUE, seed=seed, silent=TRUE)
	sink()
    if (nbrNodes==1)
    {
        ans <- siena07(simalg, data=xd1, effects=effs1,
            thetaValues=thetaValues.g, batch=TRUE, silent=TRUE, returnDeps=TRUE)
    }
    else
    {
        ans <- siena07(simalg, data=xd1, effects=effs1,
            thetaValues=thetaValues.g, useCluster=TRUE, nbrNodes=nbrNodes,
            batch=TRUE, silent=TRUE, returnDeps=TRUE)
    }
    ans$nact <- length(xd1$nodeSets[[1]])
    ans
}


