
##*****************************************************************************
## * SIENA: Simulation Investigation for Empirical Network Analysis
## *
## * Web: https://www.stats.ox.ac.uk/~snijders/siena
## *
## * File: multiExtra.r
## *
## * Description: This file contains several R functions taken from various 
## * files of RSiena, of which only a small part of the contents was needed 
## * for multiSiena.
## ****************************************************************************/


##@storeinFRANstore siena07 Used to avoid Namespace problems with multiple processes
storeinFRANstore <- function(...)
{
    FRANstore(...)
}


##@clearData siena07 Finalizer to clear Data object in C++
clearData <- function(pData)
{
    .Call(C_deleteData, PACKAGE=pkgname, pData)
}

##@clearModel siena07 Finalizer to clear Model object in C++
clearModel <- function(pModel)
{
    .Call(C_deleteModel, PACKAGE=pkgname, pModel)
}

##@makeZsmall siena07 create a minimal version of z to pass between processors.
makeZsmall <- function(z)
{
	zsmall <- NULL
	zsmall$theta <- z$theta
	zsmall$Deriv <- z$Deriv
	zsmall$Phase <- z$Phase
	zsmall$nit <- z$nit
	zsmall$FinDiff.method <- z$FinDiff.method
	zsmall$int2 <- z$int2
	zsmall$cl <- z$cl
	zsmall$maxlike <- z$maxlike
	zsmall$cconditional <- z$cconditional
	zsmall$condvar <- z$condvar
	zsmall$pp <- z$pp
	zsmall$nrunMH <- z$nrunMH
	zsmall$returnDeps <- z$returnDeps
	zsmall$returnChains <- z$returnChains
	zsmall$returnDataFrame <- z$returnDataFrame
	zsmall$addChainToStore <- z$addChainToStore
	zsmall$callGrid <- z$callGrid
	zsmall$thetaMat <- z$thetaMat
	zsmall$byWave <- z$byWave
	zsmall
}

checkImpossibleChanges <- getFromNamespace("checkImpossibleChanges","RSiena")
checkZeroChanges   <- getFromNamespace("checkZeroChanges","RSiena")
DataReport         <- getFromNamespace("DataReport","RSiena")
hasSettings        <- getFromNamespace("hasSettings","RSiena")
sienaTimeFix       <- getFromNamespace("sienaTimeFix","RSiena")
getInternals       <- getFromNamespace("getInternals","RSiena")
sienaFitThetaTable <- getFromNamespace("sienaFitThetaTable","RSiena")
credValues         <- getFromNamespace("credValues","RSiena")
fixUpEffectNames   <- getFromNamespace("fixUpEffectNames","RSiena")
#initializeFRAN     <- getFromNamespace("initializeFRAN","RSiena")
#maxlikec           <- getFromNamespace("maxlikec","RSiena")
