pdf("CIS3.pdf", pointsize=10)

od <- setwd(tempdir())

## Ex 7
y <- c(28, 8, -3, 7, -1, 1, 18, 12)
sigma.y <- c(15, 10, 16, 11, 9, 11, 10, 18)

rm(theta) # precaution to  being taken as data

# (a)
write("
model {
    for (j in 1:length(y)) {
        y[j] ~ dnorm(theta[j], tau.y[j])
        theta[j] ~ dnorm(mu.theta, tau.theta)
        tau.y[j] <- sigma.y[j] ^ -2
    }
    mu.theta ~ dnorm(0, 1.0E-6)
    tau.theta <- sigma.theta ^ -2
    sigma.theta ~ dunif(0, 1000)
}
", "schools.jags")

inits <- function()
    list(theta = rnorm(length(y),0,100), mu.theta = rnorm(1,0,100),
         sigma.theta = runif(1,0,100))
parameters <- c("theta", "mu.theta", "sigma.theta")

library(rjags)
schools.jags <- jags.model("schools.jags", inits = inits,
                           n.chains = 3, n.adapt = 10000)
schools.sim <- coda.samples(schools.jags, parameters,
                            n.iter = 10000, thin = 10)
summary(schools.sim)
plot(schools.sim)
densityplot(schools.sim)
# explore largest
str(schools.sim)
max.sim <- schools.sim
for(i in 1:3) max.sim[[i]] <- mcmc(apply(max.sim[[i]][, 3:10], 1, max))
plot(max.sim)


# (b)
write("
model {
    for (j in 1:length(y)) {
        y[j] ~ dnorm(theta[j], tau.y[j])
        theta[j] ~ dt(mu.theta, tau.theta, 4)
        tau.y[j] <- sigma.y[j] ^ -2
    }
    mu.theta ~ dnorm(0, 1.0E-6)
    tau.theta <- sigma.theta ^ -2
    sigma.theta ~ dunif(0, 1000)
}
", "schools_t4.jags")

schools_t.jags <- jags.model("schools_t4.jags", inits = inits,
                             n.chains = 3, n.adapt = 10000)
schools_t.sim <- coda.samples(schools_t.jags, parameters,
                              n.iter = 10000, thin = 10)
summary(schools_t.sim)
plot(schools_t.sim)
densityplot(schools_t.sim)

# (c)
library(coda) # may already be loaded
J <- length(y)
theta.update <- function() {
    V.theta <- 1/(1/tau^2 + 1/sigma.y^2)
    theta.hat <- (mu/tau^2 + y/sigma.y^2)*V.theta
    rnorm(J, theta.hat, sqrt(V.theta))
}
mu.update <- function() rnorm(1, mean(theta), tau/sqrt(J))
tau.update <- function() sqrt(sum((theta-mu)^2)/rchisq(1, J-1))

n.chains <- 5
n.iter <- 1000
thetai <- paste("theta[", seq_along(y), "]", sep="")
sims <- vector("list", n.chains)
for(i in 1:n.chains) {
    this <- array(, c(n.iter, J+2),
                  dimnames = list(NULL, c(thetai, "mu", "tau")))
    mu <- rnorm(1, mean(y), sd(y))
    tau <- runif(1, 0, sd(y))
    for(t in 1:n.iter) {
        theta <- theta.update(); mu <- mu.update(); tau <- tau.update()
        this[t, ] <- c(theta, mu, tau)
    }
    sims[[i]] <- as.mcmc(this)
}
z <- as.mcmc.list(sims)
summary(z)
densityplot(z)
plot(z, ask = TRUE)


# (d)
nu <- 4
mu.update <- function() rnorm(1, sum(theta/V)/sum(1/V), sqrt(1/sum((1/V))))
tau.update <- function() sqrt(rgamma(1, J*nu/2+1, (nu/2)*sum(1/V)))
V.update <- function() (nu*tau^2 + (theta-mu)^2)/rchisq(J, nu+1)

for(i in 1:n.chains) {
    this <- array(, c(n.iter, J+2),
                  dimnames = list(NULL, c(thetai, "mu", "tau")))
    mu <- rnorm(1, mean(y), sd(y))
    tau <- runif(1, 0, sd(y))
    V <- runif(J, 0, sd(y))^2
    for(t in 1:n.iter) {
        theta <- theta.update(); V <- V.update()
        mu <- mu.update(); tau <- tau.update()
        this[t,] <- c(theta, mu, tau)
    }
    sims[[i]] <- as.mcmc(this)
}
z <- as.mcmc.list(sims)
summary(z)
densityplot(z)
plot(z, ask = TRUE)

# (e)
log.post <- function(V, tau, nu)
    sum(log(nu) + 2*log(tau/V) + dchisq(nu*tau^2/V, nu, log=TRUE))

nu.update <- function(sigma.jump.nu = 1)
{
    nu.inv.star <- rnorm(1, 1/nu, sigma.jump.nu)
    if(nu.inv.star > 0 && nu.inv.star <= 1) {
        nu.star <- 1/nu.inv.star
        lratio <- log.post(V, tau, nu.star) - log.post(V, tau, nu)
        nu <- ifelse(lratio > -rexp(1), nu.star, nu)
    }
    nu
}

for(i in 1:n.chains) {
    this <- array(, c(n.iter, J+4),
                  dimnames = list(NULL, c(thetai, "mu", "tau", "nu", "1/nu")))
    mu <- rnorm(1, mean(y), sd(y))
    tau <- runif(1, 0, sd(y))
    V <- runif(J, 0, sd(y))^2
    nu <- 1/runif(1, 0, 1)
    for(t in 1:n.iter) {
        theta <- theta.update(); V <- V.update()
        mu <- mu.update(); tau <- tau.update(); nu <- nu.update()
        this[t,] <- c(theta, mu, tau, nu, 1/nu)
    }
    sims[[i]] <- as.mcmc(this)
}
z <- as.mcmc.list(sims)
summary(z)
plot(z, ask = TRUE)


## Ex 9
library(MASS)
make.aidsp <- function() {
  cutoff <- 10043 # 1987-07-01 with origin 1960-01-01
  btime <- pmin(cutoff, Aids2$death) - pmin(cutoff, Aids2$diag)
  atime <- pmax(cutoff, Aids2$death) - pmax(cutoff, Aids2$diag)
  survtime <- btime + 0.5*atime
  status <- as.numeric(Aids2$status)
  data.frame(survtime, status = status - 1, state = Aids2$state,
    T.categ = Aids2$T.categ, age = Aids2$age, sex = Aids2$sex)
}
Aidsp <- make.aidsp()
library(survival)
fit <- survreg(Surv(survtime + 0.9, status) ~ T.categ + age,
               data = Aidsp, subset = (state == "NSW"))
summary(fit)

library(LearnBayes)
weibullregpost <- function(theta, data)
{
    sigma <- exp(theta[1]); beta <- theta[-1]
    lp <- drop(data[, -(1:2), drop=FALSE] %*% beta)
    zi <- (log(data[,1]) - lp)/sigma
    fi <- 1/sigma * exp(zi - exp(zi))
    Si <- exp(-exp(zi))
    sum(log(ifelse(data[,2], fi, Si)))
}
start <- t(c(log(fit$scale), coef(fit)))
mf <- model.frame(fit)
d <- cbind(mf[[1]], model.matrix(terms(fit), mf))
fit0 <- laplace(weibullregpost, start, d)

proposal <- list(var=fit0$var, scale=0.5)
bf <- rwmetrop(weibullregpost, proposal, fit0$mode, 1000, d)
bf$accept
res <- bf$par
res[,1] <- exp(res[,1])
colnames(res) <- c("shape", names(coef(fit)))
library(coda)
res <- as.mcmc(res)
plot(res)
acfplot(res)

## with more time:
if(FALSE) {
res <- rwmetrop(weibullregpost, proposal, fit0$mode, 1e5, d)$par
res[,1] <- exp(res[,1])
colnames(res) <- c("shape", names(coef(fit)))
res <- window(as.mcmc(res), thin = 50)
plot(res)
acfplot(res)
densityplot(res)
}


# memory.size(max = TRUE)
