pdf("CIS2.pdf", pointsize=10)

## Ex 4
ldose <- rep(0:5, 2)
numdead <- c(1, 4, 9, 13, 18, 20, 0, 2, 6, 10, 12, 16)
sex <- factor(rep(c("M", "F"), c(6, 6)))
SF <- cbind(numdead, numalive = 20 - numdead)
resp <- rep(rep(c(1,0), 12), times = t(SF))
budworm <- data.frame(resp, ldose = rep(ldose, each = 20),
                      sex = rep(sex, each = 20))
summary(glm(resp ~ sex*ldose, family = binomial, data = budworm))

library(MCMCpack)  # loads package 'coda'
fit <- MCMClogit(resp ~ sex*ldose, data = budworm)
summary(fit)
effectiveSize(fit)
plot(fit)
acfplot(fit) # suggests thinning
crosscorr.plot(fit)
fit <- MCMClogit(resp ~ sex*ldose, data = budworm, mcmc = 1e5, thin = 20)
summary(fit)
HPDinterval(fit)

## plot beta (slope) vs alpha (intercept) for females
library(MASS)
contour(kde2d(fit[,1], fit[,3], n=50), xlab="alphaF", ylab="betaF")
points(fit[, c(1,3)], pch=20, cex=0.5, col=rgb(0,0,1,0.2))
## create some new objects, the LD50s in a form suitable for coda.
ld50F <- as.mcmc(2 ^ (-fit[,1]/fit[,3]) )
ld50M <- as.mcmc(2 ^ (-(fit[,1]+fit[,2])/(fit[,3] + fit[,4])) )
range(ld50M); range(ld50F)
ld50 <- mcmc(cbind(M=ld50M, F=ld50F))
plot(ld50)
acfplot(ld50)
HPDinterval(ld50)


## Ex 5
## the current directory must be writable here.
od <- setwd(tempdir())
write("
model {
   for(i in 1:6) {
      numdead[i] ~ dbin(p[i], 20)
      logit(p[i]) <- alphaM + betaM * ldose[i]
   }
   for(i in 7:12) {
      numdead[i] ~ dbin(p[i], 20)
      logit(p[i]) <- alphaF + betaF * ldose[i]
   }
   betaM ~ dnorm(0.0, 0.001)
   alphaM ~ dnorm(0.0, 0.001)
   betaF ~ dnorm(0.0, 0.001)
   alphaF ~ dnorm(0.0, 0.001)
}
", "budworm.jags")

inits <- function()
   list(alphaM = rnorm(1,0,10), betaM = rnorm(1),
        alphaF = rnorm(1,0,10), betaF = rnorm(1))

library(rjags)
load.module('glm')  # tell JAGS about better algorithms for GLMs
## discard 5000, record 5000
bd.jags <- jags.model("budworm.jags", inits = inits, n.chains = 1,
                      n.adapt = 5000)
vars <- c("alphaM", "alphaF", "betaM", "betaF")
bd.sims <- coda.samples(bd.jags, vars, n.iter = 5000)
summary(bd.sims)
plot(bd.sims)
acfplot(bd.sims, lag.max=100)
acfplot(window(bd.sims, thin=10))
bd.sims2 <- coda.samples(bd.jags, vars, n.iter = 50000, thin = 50)
acfplot(bd.sims2)

## If we give JAGS more than 4 chains we need to specify the RNG
## (and optionally the seeds)
inits2 <- lapply(1:5, function(i) c(inits(),
                                    .RNG.name="base::Mersenne-Twister",
                                    .RNG.seed=i))
bd.jags <- jags.model("budworm.jags", inits = inits2,
                      n.chains = 5, n.adapt = 500)
bd.sims <- coda.samples(bd.jags, vars, n.iter = 500)
summary(bd.sims)
plot(bd.sims)
gelman.plot(bd.sims)
densityplot(bd.sims) # and so on


## Ex 6
library(MCMCpack)

D <- c(4,5,4,1,0,4,3,4,0,6,3,3,4,0,2,6,3,3,5,4,5,
       3,1,4,4,1,5,5,3,4,2,5,2,2,3,4,2,1,3,2,1,1,1,1,
       1,3,0,0,1,0,1,1,0,0,3,1,0,3,2,2,0,1,1,1,0,1,0,
       1,0,0,0,2,1,0,0,0,1,1,0,2,3,3,1,1,2,1,1,1,1,2,
       4,2,0,0,0,1,4,0,0,0,1,0,0,0,0,0,1,0,0,1,0,1)

fit <- MCMCpoissonChange(D ~ 1, m = 1, c0 = 1, d0 = 1,
                         burnin = 10000, mcmc = 10000,
                         marginal.likelihood = "Chib95") # bug workaround
plot(fit); par(mfrow=c(1,1))
acfplot(fit)
effectiveSize(fit)
summary(fit)
plotState(fit)
plotChangepoint(fit, start = 1851)

write("
model {
  for (year in 1:length(D)) {
       D[year] ~ dpois(mu[year])
       log(mu[year]) <- b[1] + step(year - changeyear) * b[2]
  }
  for (j in 1:2) { b[j] ~ dnorm(0.0, 1.0E-6) }
  changeyear ~ dunif(1, length(D))
}
", "coalmining.jags")

inits <- list(list(b=c(0,0), changeyear=50),
              list(b=rnorm(2), changeyear=30),
              list(b=rnorm(2), changeyear=70))

cm.jags <- jags.model("coalmining.jags", inits=inits, n.chains=3)
coalmining.sim <- coda.samples(cm.jags, c("changeyear","b"), n.iter = 5000)
summary(coalmining.sim)
densityplot(coalmining.sim)
gelman.plot(coalmining.sim)
raftery.diag(coalmining.sim[[1]])
