#pdf("CIS2.pdf", pointsize=10)

## Ex 4
ldose <- rep(0:5, 2)
numdead <- c(1, 4, 9, 13, 18, 20, 0, 2, 6, 10, 12, 16)
sex <- factor(rep(c("M", "F"), c(6, 6)))
SF <- cbind(numdead, numalive = 20 - numdead)
resp <- rep(rep(c(1,0), 12), times = t(SF))
budworm <- data.frame(resp, ldose = rep(ldose, each = 20),
                      sex = rep(sex, each = 20))
summary(glm(resp ~ sex*ldose, family = binomial, data = budworm))

library(MCMCpack)  # loads package 'coda'
fit <- MCMClogit(resp ~ sex*ldose, data = budworm)
summary(fit)
effectiveSize(fit)
plot(fit)
acfplot(fit) # suggests thinning
crosscorr.plot(fit)
fit <- MCMClogit(resp ~ sex*ldose, data = budworm, mcmc = 1e5, thin = 20)
summary(fit)
HPDinterval(fit)

## plot beta (slope) vs alpha (intercept) for females
library(MASS)
contour(kde2d(fit[,1], fit[,3], n=50), xlab="alphaF", ylab="betaF")
points(fit[, c(1,3)], pch=20, cex=0.5, col=rgb(0,0,1,0.2))
## create some new objects, the LD50s in a form suitable for coda.
ld50F <- as.mcmc(2 ^ (-fit[,1]/fit[,3]) )
ld50M <- as.mcmc(2 ^ (-(fit[,1]+fit[,2])/(fit[,3] + fit[,4])) )
range(ld50M); range(ld50F)
ld50 <- mcmc(cbind(M=ld50M, F=ld50F))
plot(ld50)
acfplot(ld50)
HPDinterval(ld50)


## Ex 5
library(BRugs)
options(BRugsVerbose = FALSE)
## the current directory must be writable here.
od <- setwd(tempdir())
write("
model {
   for(i in 1:6) {
      numdead[i] ~ dbin(p[i], 20)
      logit(p[i]) <- alphaM + betaM * ldose[i]
   }
   for(i in 7:12) {
      numdead[i] ~ dbin(p[i], 20)
      logit(p[i]) <- alphaF + betaF * ldose[i]
   }
   betaM ~ dnorm(0.0, 0.001)
   alphaM ~ dnorm(0.0, 0.001)
   betaF ~ dnorm(0.0, 0.001)
   alphaF ~ dnorm(0.0, 0.001)
}
", "budworm.bug")

inits <- list(list(alphaM = 0, betaM = 0, alphaF = 0, betaF = 0))
budworm.sim <-
    BRugsFit("budworm.bug",
             data = list(numdead = numdead, ldose = ldose),
             inits = inits,
             parametersToSave = c("alphaM", "alphaF", "betaM", "betaF"),
             numChains = 1,
             nBurnin = 5000, nIter = 5000, coda = TRUE, DIC = FALSE)
summary(budworm.sim)
plot(budworm.sim)
acfplot(budworm.sim, lag.max=100)
acfplot(window(budworm.sim, thin=10))

inits <- function()
   list(alphaM = rnorm(1,0,10), betaM = rnorm(1),
        alphaF = rnorm(1,0,10), betaF = rnorm(1))

budworm.sim <-
    BRugsFit("budworm.bug",
             data = list(numdead = numdead, ldose = ldose),
             inits = inits,
             numChains = 5,
             parametersToSave = c("alphaM", "alphaF", "betaM", "betaF"),
             nBurnin = 500, nIter = 500, nThin = 1, coda = TRUE, DIC = FALSE)

summary(budworm.sim)
plot(budworm.sim)
gelman.plot(budworm.sim)
densityplot(budworm.sim) # and so on


## Ex 6
library(MCMCpack)

D <- c(4,5,4,1,0,4,3,4,0,6,3,3,4,0,2,6,3,3,5,4,5,
       3,1,4,4,1,5,5,3,4,2,5,2,2,3,4,2,1,3,2,1,1,1,1,
       1,3,0,0,1,0,1,1,0,0,3,1,0,3,2,2,0,1,1,1,0,1,0,
       1,0,0,0,2,1,0,0,0,1,1,0,2,3,3,1,1,2,1,1,1,1,2,
       4,2,0,0,0,1,4,0,0,0,1,0,0,0,0,0,1,0,0,1,0,1)
N <- length(D)

fit <- MCMCpoissonChange(D ~ 1, m = 1, c0 = 1, d0 = 1,
                         burnin = 10000, mcmc = 10000,
                         marginal.likelihood = "Chib95") # bug workaround
plot(fit); par(mfrow=c(1,1))
acfplot(fit)
effectiveSize(fit)
summary(fit)
plotState(fit)
plotChangepoint(fit, start = 1851)

library(BRugs)
write("
model {
  for (year in 1:N) {
       D[year] ~ dpois(mu[year])
       log(mu[year]) <- b[1] + step(year - changeyear) * b[2]
  }
  for (j in 1:2) { b[j] ~ dnorm(0.0, 1.0E-6) }
  changeyear ~ dunif(1,N)
}
", "coalmining.bug")

inits <- list(list(b=c(0,0), changeyear=50),
              list(b=rnorm(2), changeyear=30),
              list(b=rnorm(2), changeyear=70))

coalmining.sim <-
    BRugsFit(data = list(N = length(D), D = D), inits = inits,
             param = c("changeyear","b"),
             model = "coalmining.bug",
             numChains = 3, nIter = 5000, DIC = FALSE, coda = TRUE)

summary(coalmining.sim)
plot(coalmining.sim)
