pdf("CIS1.pdf")

## Ex 1
library(MASS)
shoes
with(shoes, t.test(A, B, paired=TRUE))
d <- with(shoes, A - B)
t.test(d)
R <- 999
tperm <- numeric(R)
for(i in seq_len(R)) {
    a <- 2*rbinom(10, 1, 0.5) - 1
    tperm[i] <- t.test(a*d)$statistic
}

op <- par(mfrow = c(1, 2))
truehist(tperm, xlab = "diff", xlim=c(-5,5))
lines(density(tperm), lty=2)
x <- seq(-5, 5, 0.1)
lines(x, dt(x,9))
plot(ecdf(tperm), xlim=c(-5,5), do.points=FALSE)
lines(x, pt(x,9), lty=3)
par(op)

t0 <- t.test(d)$statistic
sum(abs(tperm) > abs(t0))/(R+1)

## Ex 2
library(MASS); library(boot)
cd4.rg <- function(data, mle) mvrnorm(nrow(data), mle$m, mle$v)

cd4.mle <- list(m=mean(cd4), v=var(cd4))
cd4.boot <- boot(cd4, corr, R=999,
                 sim = "parametric", ran.gen = cd4.rg, mle = cd4.mle)
cd4.boot
boot.ci(cd4.boot, type=c("norm", "basic", "perc"), conf=0.9)
boot.ci(cd4.boot,  type=c("norm", "basic", "perc"), conf=0.9,
        h=atanh, hinv=tanh)

cd4.boot <- boot(cd4, corr, stype="w", R=999)
cd4.boot
boot.ci(cd4.boot, conf=0.9)
boot.ci(cd4.boot, conf=0.9, h=atanh, hinv=tanh)

corr.fun <- function(d, w = rep(1, n))
{
    n <- nrow(d)
    w <- w/sum(w)
    m1 <- sum(d[,1]*w); m2 <- sum(d[,2]*w)
    v1 <- sum(d[,1]^2*w) - m1^2; v2 <- sum(d[,2]^2*w) - m2^2
    rho <- (sum(d[,1]*d[,2]*w) - m1*m2)/sqrt(v1 * v2)
    i <- rep(1:n, round(n*w))
    us <- (d[i, 1] - m1)/sqrt(v1)
    xs <- (d[i, 2] - m2)/sqrt(v2)
    L <- us*xs - 0.5*rho*(us^2 + xs^2)
    c(rho, sum(L^2)/n^2)
}
cd4.boot <- boot(cd4, corr.fun, stype="w", R=999)
boot.ci(cd4.boot, type="stud", conf=0.9)
boot.ci(cd4.boot, type="stud", conf=0.9,
        h=atanh, hdot=function(r) 1/(1-r^2), hinv=tanh)

page(nested.corr) # a function in the 'boot' package
cd4m <- unname(as.matrix(cd4)) # 4x faster to use a matrix without names
## we make use of the byte-compilation of R 2.13.0 to speed this up ca 25%
library(compiler); enableJIT(3)
R <- 499; M <- 499
cd4.nest <- boot(cd4m, nested.corr, R=R, stype="w", t0=corr(cd4), M=M)
enableJIT(0)

op <- par(pty = "s", xaxs = "i", yaxs = "i")
qqplot((1:R)/(R+1), cd4.nest$t[, 2], pch = ".", asp = 1,
        xlab = "nominal", ylab = "estimated")
abline(a = 0, b = 1, col = "grey")
par(op)
abline(h=0.05, col = "grey")
abline(h=0.95, col = "grey")

nominal <- (1:R)/(R+1)
actual <- cd4.nest$t[, 2]
100*nominal[c(sum(actual <= 0.05), sum(actual < 0.95))]

## Ex 3
library(spatial)
towns <- ppinit("towns.dat")
tget <- function(x, r=3.5) sum(dist(cbind(x$x, x$y)) < r)
t0 <- tget(towns)
R <- 100
c <- seq(0, 1, 0.2)
## res[1] = 0
res <- c(0, sapply(c[-1], function(c)
    mean(replicate(R, tget(Strauss(69, c=c, r=3.5))))))
plot(c, res, type="l", ylab="E t")
abline(h=t0, col="grey")

R <- 1000
c <- seq(0.4, 0.6, len=6)
res <- numeric(length(c))
sds <- numeric(length(c))
for(i in seq_along(c)) {
    z <- replicate(R, tget(Strauss(69, c=c[i], r=3.5)))
    res[i] <- mean(z)
    sds[i] <- sd(z)/sqrt(R)
}
plot(c, res, type="l", ylab="E t")
abline(h=t0, col="grey")
abline(lm(res ~ c))
arrows(c, res-1.96*sds, c, res+1.96*sds,
       angle=90, code=3, length=0.1, xpd=TRUE)

c0 <- 0.50
rs <- replicate(R, tget(Strauss(69, c=c0, r=3.5)))
c <- seq(0.4, 0.6, len=20)
res <- numeric(length(c))
for(i in seq_along(c))
    res[i] <- mean(rs * (c[i]/c0)^rs)/mean((c[i]/c0)^rs)
points(c0, mean(rs), col="blue"); lines(c, res, col="blue")

R <- 1000
doit <- function(ave=FALSE, gam=0.7) {
    res <- numeric(R)
    c <- runif(1, 0.4, 0.6) # initial guess.
    for(i in 1:R) {
        a <- 0.5*(i+5)^-gam
        err <- tget(Strauss(69, c=c, r=3.5))/t0  - 1
        c <- c - a*err
        res[i] <- c
    }
    if(ave) cumsum(res)/(1:R) else res
}
res <- doit()
plot(res, type="l", ylim=c(0.4, 0.6))
for(i in 2:5) lines(doit(), col=i)

## or average
res <- doit(TRUE)
plot(res, type="l", ylim=c(0.4, 0.6))
for(i in 2:5) lines(doit(TRUE), col=i)
