#
# Test a claim by James Schimert, about speed of rpart vs tree
#

timeit <- function(ngrp, n) {
    x <- rep(1:ngrp, length=n)
    y <- rep(1:4, length=n)
    time1 <- proc.time()
    fit1 <- tree(factor(y) ~ factor(x),
		 control=tree.control(minsize=n, mindev=0, mincut=1,
		                      nobs=n))
    time2 <- proc.time()
    fit2 <- rpart(factor(y) ~ factor(x), parms=list(split='information'), 
		  control=rpart.control(minsplit=n, minbucket=1,surrogate=0,
		                        cp=0, xval=0))
    time3 <- proc.time()
    list(tree=fit1, rpart=fit2, 
	 times=as.vector(cbind(ime2-time1, time3-time2) %*% c(1,1,0)))
    }

cattest1 <- timeit(10)
cattest2 <- timeit(20)
