#
# Here is a special program written at the behest of a user.
#  He wants a SAS program that will create the predicted node number
#  for each subject.
# The code is 99% a copy of print.rpart.
# The code does generate correct SAS code for factors, e.g., you will get
#   a line like "if (Type=Large,Medium,Van)".  It would be possible to
#   post-process such strings  -- a job for another day.
sascode.rpart <- function(x, minlength=0, spaces=3, cp, 
               digits=.Options$digits, ...) {
    if(!inherits(x, "rpart")) stop("Not legitimate rpart object")
    if (!is.null(x$frame$splits)) x <- rpconvert(x)  #help for old objects

    if (!missing(cp)) x <- prune.rpart(x, cp=cp)
    frame <- x$frame
    node <- as.numeric(row.names(frame))
    depth <- tree.depth(node) 
    indent <- paste(rep(" ", spaces * 32), collapse = "")   
    #32 is the maximal depth
    if(length(node) > 1) {
        indent <- substring(indent, 1, spaces * 1:max(depth))
	indent <- c("", indent[depth])
        }
    else stop("Tree has only 1 node")
    
    # this is the ending part of each line
    term <- ifelse(frame$var == "<leaf>", paste("then rpnode=", node, ";"), 
		                                "then do;")
    # the first part of the line 
    z <- labels(x, digits=digits, minlength=minlength, ...)
    z <- paste(indent, "if (", z, ") ", sep='')

    # add in the "end" statements that go with each "do"
    delta  <- -diff(c(depth,1))   #leftward movement of the indent
    temp <- paste(rep("end;", max(delta)), collapse=' ')
    endlist <- substring(temp, 1, 5*delta)
    endstring <- ifelse(delta>0, paste("\n", indent, endlist, sep=''), "")
    z <- paste(z, term, endstring, sep='')

    cat(z[-1], sep = "\n")  # the -1 prevents listing the root node
    return(invisible(x))
    }
