/*
**  SCCS @(#)rpart_callback.c	1.4 08/13/01
** callback routines for "user" splitting functions in rpart
*/
#include "S.h"
#include "rpart.h"
#include "rpartproto.h"
/* taken from eval.h in SHOME/include -- should be part of S.h*/
extern s_object *S_STDCALL get_frame_pointer(long i, s_evaluator *S_evaluator);

static Sint nframe;
static Sint ysave;       /* number of columns of y  */
static Sint rsave;       /* the length of the returned "mean" from the
			      user's eval routine */
static s_object *expr1;  /* the evaluation expression for splits */
static s_object *expr2;  /* the evaluation expression for values */

static double *ydata;   /* pointer to the data portion of yback */
static double *xdata;	/* pointer to the data portion of xback */
static double *wdata;	/* pointer to the data portion of wback */
static Sint   *ndata;	/* pointer to the data portion of nback */


/*
** The first routine saves away the parameters, the location
**   of the evaluation frame and the 2 expressions to be computed within it,
**   and ferrets out the memory location of the 4 "callback" objects.
*/
s_object *init_rpcallback(s_object *frame, s_object *ny, s_object *nr,
			  s_object *expr1x, s_object *expr2x) {
    S_EVALUATOR
    s_object *stemp;

    nframe = INTEGER_VALUE(frame);/* the frame number for evaluation */
    ysave  = INTEGER_VALUE(ny );
    rsave  = INTEGER_VALUE(nr);
    expr1  = expr1x;
    expr2  = expr2x;

    stemp = GET_FROM_FRAME("yback", nframe);  /*find memory location of yback*/
    ydata = NUMERIC_POINTER(stemp);
    stemp = GET_FROM_FRAME("wback", nframe); 
    wdata = NUMERIC_POINTER(stemp);
    stemp = GET_FROM_FRAME("xback", nframe); 
    xdata = NUMERIC_POINTER(stemp);
    stemp = GET_FROM_FRAME("nback", nframe);  
    ndata = INTEGER_POINTER(stemp);

    return(frame);   /* From the docs, it appears that I have to 
				 return something */
    }

/*
** This is called by the usersplit init function
**  For the "hardcoded" user routines, this is a constant written into
**  their init routine, but here we need to grab it from outside.
*/
void rpart_callback0(int *nr) {
    *nr = rsave;
    }

/*
** This is called by the evaluation function
*/
void rpart_callback1(int n, double *y[], double *wt, double *z) {
    int i,j, k;
    s_object *value;
    double *dptr;

    /* Copy n and wt into the parent frame */
    k=0;
    for (i=0; i<ysave; i++) {
	for (j=0; j<n; j++) {
	    ydata[k] = y[j][i];
	    k++;
	    }
	}

    for (i=0; i<n; i++) {
	wdata[i] = wt[i];
	}
    ndata[0] = n;

    /* 
    **  Evaluate the saved expression in the parent frame
    **   The result should be a vector of numerics containing the
    **   "deviance" followed by the "mean"
    */
    value = EVAL_IN_FRAME(expr2, nframe);
    if (!IS_NUMERIC(value)) PROBLEM "return value not a vector" ERROR;
    if (LENGTH(value) != (1 + rsave))
	PROBLEM "returned value is the wrong length" ERROR;
    dptr = NUMERIC_POINTER(value);
    for (i=0; i<=rsave; i++) z[i] = dptr[i];
    }

/*
** This part is called by the rpart "split" function
**   It is expected to return an n-1 length vector of "goodness of split"
*/
void rpart_callback2(int n, int ncat, double *y[], double *wt, 
		     FLOAT *x, double *good) {
    S_EVALUATOR
    int i, j, k;
    s_object *goodness, *fpointer;
    double *dptr;
    /* 
    ** Assign the weight, x, and y vectors into the parent frame,
    **  and evaluate the expression.
    ** It is important that yback and wback be treated as "read only" objects
    **  in the parent frame, since we replace (again and again) the elements
    **  of the vectors without checking to see that they have not been 
    **  supplanted by a new copy.  In some sense, calling ASSIGN_IN_FRAME
    **  each time we entered this routine would be safer, except for the fact
    **  that in this version (6.0) reassigning the same object into a frame
    **  more than once crashes Splus.
    ** The expression is expected to return a numeric vector.
    */
    k=0;
    for (i=0; i<ysave; i++) {
	for (j=0; j<n; j++) {
	    ydata[k] = y[j][i];
	    k++;
	    }
	}

    for (i=0; i<n; i++) {
	wdata[i] = wt[i];
	xdata[i] = x[i];
	}
    if (ncat >0) {
	ndata[0] = -n;  /*the negative serves as a marker for rpart.s */
	}
    else ndata[0] =n;  

    goodness = EVAL_IN_FRAME(expr1, nframe);
    if (!IS_NUMERIC(goodness)) PROBLEM
			       "The expression expr1 did not return a vector!"
			                ERROR;
    j = LENGTH(goodness);

    /* yes, the lengths have already been checked in the C code  ---
       call this extra documenation then */
    if (ncat==0) {
	if (j != 2*(n-1)) PROBLEM
	  "The expression expr1 returned a list of %d elements, %d required",
		   j, 2*(n-1)    ERROR;

	dptr = NUMERIC_POINTER(goodness);
	for (i=0; i<j; i++) good[i] = dptr[i];
	}
    else {
	/* 
	** If not all categories were present in X, then the return list
	**   will have 2(#categories present) -1 elements
	** The first element of "good" contains the number of groups found
	*/
	dptr = NUMERIC_POINTER(goodness);
	good[0] = (j+1)/2;
	for (i=0; i<j; i++) good[i+1] = dptr[i];
	}

    /* 
    **  The "goodness" object has a reference count of 0, i.e., S can
    ** reuse the memory any time it wants.  Per a private note from
    ** Bill Dunlap, the memory will not get reclaimed unless we force it:
    ** "memory with ref count 0 doesn't get freed -- it only is freed if 
    ** its ref count drops to 0."
    **   The three lines below are not needed in R, which reclaims memory 
    ** whenever a) you ask for more and there isn't enough currently free, or
    ** on an error.  (This also means that we can count on both packages not
    ** to do a reclaim before we were done with the 'goodness' vector).
    */
    fpointer = (s_object *)get_frame_pointer(nframe, S_evaluator);
    incr_ref_count(goodness, S_TRUE, fpointer, S_evaluator);
    decr_ref_count(goodness, S_TRUE, fpointer, S_evaluator);
    }
