# SCCS 05/11/01 @(#)post.rpart.s	1.13
#
post.rpart <- function(tree, title, 
		       filename=paste(deparse(substitute(tree)),".ps",sep=""),
		       digits=  .Options$digits, pretty=T, 
		       use.n=T,  horizontal=T, ...) {
    if(filename !=""){
	postscript(file = filename, horizontal=horizontal, ...)
	par(mar=c(2,2,4,2)+.1)
	on.exit(dev.off())
	}
    else {
	oldpar <- par(mar=c(2,2,4,2)+.1)
	on.exit(invisible(par(oldpar)))
	}

    plot(tree, uniform=T, branch=.2, compress=T, margin=.1)
    text(tree, all=T, use.n=use.n, fancy=T, digits=digits, pretty=pretty)
    method <- tree$method

    # trickery to avoid warning message about "title" being both a variable
    #  and a function  One frame down, the variable 'title' is not visible
    tempfun <- function(x)  title(x, cex=.8)

    if(missing(title)) {
	temp  <- attr(tree$terms,'variables')[1]	      
	tempfun(paste("Endpoint =",temp))
	}
    else if (title !="") tempfun(title)
    }

