# file spatial/First.q copyright (C) 1994-2002 W. N. Venables and B. D. Ripley
#
.First.lib <- function(library, section)
{
    cat("spatial library for Venables & Ripley (2002) version 7.0\n\n")
    cat("This library is provided by Venables & Ripley <MASS@stats.ox.ac.uk>",
        "It is not supported by Insightful. Use the command",
        "`library(spatial, help=T)' to view the `readme.txt' file for this library.\n\n", sep="\n")
    assign(".sp.lib.name", paste(library, section, "data", sep="/"), frame=0)
}

.on.attach <- function()
{
  paths <- search("paths")
  which <- seq(along=paths)[regexpr("/spatial$" , paths) > 0]
  if(!is.null(which)) where <- paths[which[1]]
  else return()
  if(is.shome <- regexpr("^$SHOME", where)) {
    where <- paste(getenv("SHOME"), substring(where, 7), sep="")
  }
  assign(".sp.lib.name", where, frame=0)
}
