addNnetMenus <- function()
{
    if(!exists("guiCreate")) stop("Not running under the GUI")

    stat.loc <-
        guiGetPropertyValue("MenuItem",
                            Name=paste(guiGetMenuBar(),"$Statistics", sep="$"),
                            PropName="Index")
    menu.name <- paste(guiGetMenuBar(),"nnet", sep="$")
    item.names <- guiGetObjectNames("MenuItem")
    mass.items <- item.names[grep("\\$MASS", item.names)]
    if(length(mass.items)) stat.loc <- as.numeric(stat.loc) + 1
    guiCreate("MenuItem",
              Name=menu.name, Type="Menu",
              MenuItemText= "&Neural Nets", Index=as.numeric(stat.loc) + 1,
              OverWrite=F)

    # =============   multinom   ===============

    # Main menu
    guiCreate("MenuItem",
              Name=paste(menu.name, "Multinom", sep="$"),
              Type="MenuItem", Action="Function", Command="menuMultinom",
              MenuItemText= "Multinom...")

    # Context menus
    guiCreate("ClassInfo", Name="multinom", ContextMenu="multinom",
              DoubleClickAction = "tabResults.multinom")
    guiCreate("MenuItem", Name="multinom", Type="Menu",
              DocumentType="multinom")

    guiCreate("MenuItem", Name="multinom$Summary", Type="MenuItem",
              DocumentType="multinom", Action="Function",
              Command="tabResults.multinom", MenuItemText="Summary...",
              ShowDialogOnRun=T)
    guiCreate("MenuItem", Name="multinom$Predict", Type="MenuItem",
              DocumentType="multinom", Action="Function",
              Command="tabPredict.multinom", MenuItemText="Predict...",
              ShowDialogOnRun=T)
    guiCreate("MenuItem", Name="multinom$Coefficients", Type="MenuItem",
              DocumentType="multinom", Action="Function",
              Command="coefficients", MenuItemText="Coefficients",
              ShowDialogOnRun=F)


    # ==================   nnet  =================

    # Main menu
    guiCreate("MenuItem",
              Name=paste(menu.name, "NeuralNet", sep="$"),
              Type="MenuItem", Action="Function", Command="menuNnet",
              MenuItemText= "&Neural Net...")

    # Context menus
    guiCreate("ClassInfo", Name="nnet", ContextMenu="nnet",
              DoubleClickAction = "tabResults.nnet")
    guiCreate("MenuItem", Name="nnet", Type="Menu",
              DocumentType="nnet,nnet.formula")

    guiCreate("MenuItem", Name="nnet$Summary", Type="MenuItem",
              DocumentType="nnet,nnet.formula", Action="Function",
              Command="tabResults.nnet", MenuItemText="Summary...",
              ShowDialogOnRun=T)
    guiCreate("MenuItem", Name="nnet$Predict", Type="MenuItem",
              DocumentType="nnet,nnet.formula", Action="Function",
              Command="tabPredict.nnet", MenuItemText="Predict...",
              ShowDialogOnRun=T)
    guiCreate("MenuItem", Name="nnet$Coefficients", Type="MenuItem",
              DocumentType="nnet,nnet.formula", Action="Function",
              Command="coefficients", MenuItemText="Coefficients",
              ShowDialogOnRun=F)

    lib <- searchPaths()[match("nnet", search())]
    guiLoadDefaultObjects("Property",
                          FileName = paste(lib, "nnetprop.dft", sep = "/"))
    guiLoadDefaultObjects("FunctionInfo",
                          FileName = paste(lib, "nnetfun.dft", sep = "/"))

    cat("Nnet menus and dialogs added\n")
}

removeNnetMenus <- function()
{
    if(!exists("guiRemove")) stop("Not running under the GUI")
    item.names <- guiGetObjectNames("MenuItem")
    nnet.items <- item.names[grep("\\$nnet\\$", item.names)]
    for (i in nnet.items) guiRemove("MenuItem", name = i)
    guiRemove("MenuItem", name = item.names[grep("\\$nnet$", item.names)])

    # multinom

    guiRemove("ClassInfo", Name="multinom")
    guiRemove("MenuItem", Name="multinom")

    cat("Nnet menus and dialogs removed\n")
}

backFormNnet <- function(data)
{
    initialmsg <- cbIsInitDialogMessage(data)
    activeprop <- cbGetActiveProp(data)
    activevalue <- cbGetCurrValue(data, activeprop)
    if(initialmsg) {
        if(exists(cbGetCurrValue(data, "SPropDataFrameList"))) {
            data <- spropColName(data, "SPropDataFrameList", "SPropDependent")
            list.x <- paste("<ALL>",
                            cbGetOptionList(data, "SPropDependent"), sep = ",")
            data <- cbSetOptionList(data, "SPropIndependent", list.x)
        }
        data <- cbSetCurrValue(data, "SPropDependent", "")
        data <- cbSetCurrValue(data, "SPropIndependent", "")
    }
    switch(activeprop,
           SPropDataFrameList = {
               if(exists(cbGetCurrValue(data, "SPropDataFrameList"))) {
                   data <- spropColName(data, "SPropDataFrameList",
                                        "SPropDependent")
                   list.x <- paste("<ALL>",
                                   cbGetOptionList(data, "SPropDependent"),
                                   sep = ",")
                   data <- cbSetOptionList(data, "SPropIndependent", list.x)
               }
               data <- cbSetCurrValue(data, "SPropDependent", "")
               data <- cbSetCurrValue(data, "SPropIndependent", "")
           }
           ,
           SPropDependent = {
               new.formula <-
                   spropMakeFormula(cbGetCurrValue(data, "SPropPFFormula"),
                                    cbGetCurrValue(data, "SPropDependent"))
               data <- cbSetCurrValue(data, "SPropPFFormula", new.formula)
           }
           ,
           SPropIndependent = {
               new.formula <-
                   spropMakeFormula(cbGetCurrValue(data, "SPropPFFormula"),  ,
                                    cbGetCurrValue(data, "SPropIndependent"))
               data <- cbSetCurrValue(data, "SPropPFFormula", new.formula)
           }
           ,
           SPropPFFormula = {
               # Clear dependent and independent current values
               data <- cbSetCurrValue(data, "SPropDependent", "")
               data <- cbSetCurrValue(data, "SPropIndependent", "")
           }
           ,
           SPropPFButton =
           if(exists(cbGetCurrValue(data, "SPropDataFrameList"))) {
               guiModify(classname = "Property",
                         Name = "SPropCFFormulaID",
                         DialogControl = "Invisible",
                         DefaultValue = cbGetDialogId(data))
               guiModify(classname = "Property",
                         Name = "SPropCFData",
                         DialogControl = "Invisible",
                         DefaultValue = cbGetCurrValue(data,
                         "SPropDataFrameList"))
               guiModify(classname = "Property",
                         Name = "SPropCFFormula",
                         DefaultValue = cbGetCurrValue(data, "SPropPFFormula"))
               guiDisplayDialog(classname = "Function", Name = "makeFormulaLm")
               data <- cbSetEnableFlag(data, "SPropDataFrameList", F)
               data <- cbSetEnableFlag(data, "SPropPFFormula", F)
               data <- cbSetEnableFlag(data, "SPropPFButton", F)
               data <- cbSetCurrValue(data, "SPropDependent", "")
               data <- cbSetCurrValue(data, "SPropIndependent", "")
               data <- cbSetEnableFlag(data, "SPropDependent", F)
               data <- cbSetEnableFlag(data, "SPropIndependent", F)
           } else guiCreate("MessageBox", String =
                            "Data Frame doesn't exist. Enter Data Frame before building formula."),
           SPropPFEnableButton = {
               data <- cbSetEnableFlag(data, "SPropDataFrameList", T)
               data <- cbSetEnableFlag(data, "SPropPFFormula", T)
               data <- cbSetEnableFlag(data, "SPropPFButton", T)
               data <- cbSetEnableFlag(data, "SPropDependent", T)
               data <- cbSetEnableFlag(data, "SPropIndependent", T)
           }, # ignore all the rest
           )
    data
}


# ====== multinom =======



backMultinom <- function(data)
{
    data <- backFormNnet(data)
    activeprop <- cbGetActiveProp(data)
    activevalue <- cbGetCurrValue(data, activeprop)
    switch(activeprop,
           multinomResultsShort = if(activevalue == "T") {
               data <- cbSetCurrValue(data, "multinomResultsLong", F)
               data <- cbSetEnableFlag(data, "multinomResultsCorr", F)
           }
           ,
           multinomResultsLong = {
               if(activevalue == "T")
                   data <- cbSetCurrValue(data, "multinomResultsShort", F)
               data <- cbSetEnableFlag(data, "multinomResultsCorr",
                                       activevalue == "T")
           },                           # ignore the rest
           )
    data
}

backResults.multinom <- function(data)
{
    initialmsg <- cbIsInitDialogMessage(data)
    activeprop <- cbGetActiveProp(data)
    activevalue <- cbGetCurrValue(data, activeprop)
    if(initialmsg) data <- cbSetEnableFlag(data, "multinomHessSave", F)
    switch(activeprop,
           multinomResultsShort = if(activevalue == "T") {
               data <- cbSetCurrValue(data, "multinomResultsLong", F)
               data <- cbSetEnableFlag(data, "multinomResultsCorr", F)
           }
           ,
           multinomResultsLong = {
               if(activevalue == "T")
                   data <- cbSetCurrValue(data, "multinomResultsShort", F)
               data <- cbSetEnableFlag(data, "multinomResultsCorr",
                                       activevalue == "T")
           }
           )
    data
}

menuMultinom <- function(formula, data, weights, subset, na.omit.p=T,
                         p.short=F, p.long=T, p.corr=F, trace=F, Hess=F,
                         predict.type="raw", predict.print=F,
                         newdata=NULL, predict.save=NULL
                     )
{
    fun.call <- match.call()
    fun.call[[1]] <- as.name("multinom")
    if(na.omit.p) fun.call$na.action <- as.name("na.omit")
    else fun.call$na.action <- as.name("na.fail")
    fun.args <- is.element(arg.names(fun.call),
                           c("formula", "data", "weights", "subset",
                             "na.action", "Hess", "trace"))
    fun.call <- fun.call[c(T, fun.args)]
    #  print(fun.call)
    multinomobj <- eval(fun.call)
    if(trace) cat("\n")
    tabResults.multinom(multinomobj, p.short, p.long, p.corr)
    if(predict.print) cat("\nPredictions were:\n")
    tabPredict.multinom(multinomobj, newdata, predict.save,
                        predict.type, predict.print)
    invisible(multinomobj)
}

tabResults.multinom <- function(object, p.short=F, p.long=T, p.corr=F)
{
    if(p.short || p.long)
        cat("\n\t*** Multiple Logistic Model ***\n")
    if(p.long) print(summary.multinom(object, cor=p.corr))
    else if(p.short) print.multinom(object)
    invisible(NULL)
}

tabPredict.multinom <- function(object, newdata=NULL, predict.save=NULL,
                            predict.type="class", print.p=F)
{
    if(print.p || !is.null(predict.save)) {
        if(is.null(newdata))
            predobj <- predict(object, type=predict.type)
        else
            predobj <- predict(object, newdata=newdata, type=predict.type)
        if(print.p) print(predobj)
        if(!is.null(predict.save)) {
            if(exists(predict.save, where = 1)) {
                newsave.name <- unique.name(predict.save, where = 1)
                assign(newsave.name, predobj, where = 1)
                warning(paste("Predictions saved in", newsave.name))
            } else assign(predict.save, predobj, where = 1)
        }
    }
    invisible(NULL)
}

# ====== nnet =======

menuNnet <- function(x, data, weights, subset, na.omit.p=T,
                     size=0, decay, skip, type, maxit, seed, rang,
                     trace=T, abstol=0.0001, reltol=1e-8,
                     newdata=NULL, predict.save=NULL,
                     predict.type="raw", res.details=T, Hess=F,
                     Hess.print=F, predict.print=F
                     )
{
    fun.call <- match.call()
    #  print(fun.call)
    fun.call[[1]] <- as.name("nnet.formula")
    if(na.omit.p) fun.call$na.action <- as.name("na.omit")
    else fun.call$na.action <- as.name("na.fail")
    fun.call$linout <- fun.call$entropy <- fun.call$softmax <-
        fun.call$censored <- F
    if(type == "linear")   fun.call$linout <- T
    if(type == "entropy")  fun.call$entropy <- T
    if(type == "softmax")  fun.call$softmax <- T
    if(type == "censored") fun.call$censored <- T
    fun.args <- is.element(arg.names(fun.call),
                           c("x", "data", "weights", "subset",
                             "na.action", "size", "decay", "skip",
                             "linout", "entropy", "softmax", "censored",
                             "trace", "abstol", "reltol",
                             "maxit", "rang", "Hess"))
    fun.call <- fun.call[c(T, fun.args)]
    #  print(fun.call)
    set.seed(seed)
    nnetobj <- eval(fun.call)
    if(trace) cat("\n")
    tabResults.nnet(nnetobj, res.details)
    cat("\n")
    if(Hess.print && !is.null(nnetobj$Hessian)) {
        cat("Eigenvalues of Hessian are:\n")
        print(eigen(nnetobj$Hessian, T,T)$values)
        cat("\n")
    }
    if(predict.print) cat("Predictions were:\n")
    tabPredict.nnet(nnetobj, newdata, predict.save, predict.type,
                    predict.print)
    invisible(nnetobj)
}


backNnet <- function(data)
{
    data <- backFormNnet(data)
    activeprop <- cbGetActiveProp(data)
    activevalue <- cbGetCurrValue(data, activeprop)
    switch(activeprop,
           nnetHessSave = {
               data <- cbSetEnableFlag(data, "nnetHessPrint",
                                       activevalue=="T")
           },)
    data
}


tabResults.nnet <- function(object, details=T)
{
    cat("\n\t*** Neural Network Fit ***\n")
    if(details) print(summary.nnet(object))
    else print.nnet(object)
    invisible(NULL)
}

tabPredict.nnet <- function(object, newdata=NULL, predict.save=NULL,
                            predict.type="raw", print.p=F)
{
    if(print.p || !is.null(predict.save)) {
        if(is.null(newdata))
            predobj <- predict(object, type=predict.type)
        else
            predobj <- predict(object, newdata=newdata, type=predict.type)
        if(print.p) print(drop(predobj))
        if(!is.null(predict.save)) {
            if(exists(predict.save, where = 1)) {
                newsave.name <- unique.name(predict.save, where = 1)
                assign(newsave.name, predobj, where = 1)
                warning(paste("Predictions saved in", newsave.name))
            } else assign(predict.save, predobj, where = 1)
        }
    }
    invisible(NULL)
}


