# file nnet/knn.q copyright (C) 1994-9 W. N. Venables and B. D. Ripley
#
knn1 <- function(train, test, cl)
{
	train <- as.matrix(train)
	if(is.null(dim(test))) dim(test) <- c(1, length(test))
	test <- as.matrix(test)
	p <- ncol(train)
	ntr <- nrow(train)
	if(length(cl) != ntr) stop("train and class have different lengths")
	nte <- nrow(test)
	if(ncol(test) != p) stop("Dims of test and train differ")
	clf <- as.factor(cl)
	nc <- max(oldUnclass(clf))
	res <- .C("VR_knn1",
		  ntr, nte, p, train, oldUnclass(clf), test,
                  res = integer(nte), integer(nc+1), nc, d = double(nte)
		)$res
	factor(res, levels=seq(along=levels(clf)), labels=levels(clf))
}

knn <- function(train, test, cl, k=1, l=0, prob=F, use.all=T)
{
	train <- as.matrix(train)
	if(is.null(dim(test))) dim(test) <- c(1, length(test))
	test <- as.matrix(test)
	p <- ncol(train)
	ntr <- nrow(train)
	if(length(cl) != ntr) stop("train and class have different lengths")
	if(ntr < k) {
	   warning(paste("k =",k,"exceeds number",ntr,"of patterns"))
	   k <- ntr
	}
	if (k < 1) stop(paste("k =",k,"must be at least 1"))
	nte <- nrow(test)
	if(ncol(test) != p) stop("Dims of test and train differ")
	clf <- as.factor(cl)
	nc <- max(oldUnclass(clf))
	Z <- .C("VR_knn",
		k, l, ntr, nte, p, train, oldUnclass(clf), test,
		res = integer(nte), pr = single(nte), integer(nc+1),
		nc, F, use.all)
	res <- factor(Z$res, levels=seq(along=levels(clf)),labels=levels(clf))
	if(prob) attr(res, "prob") <- Z$pr
	res
}

knn.cv <- function(train, cl, k=1, l=0, prob=F, use.all=T)
{
	train <- as.matrix(train)
	p <- ncol(train)
	ntr <- nrow(train)
	if(ntr-1 < k) {
	   warning(paste("k =",k,"exceeds number",ntr-1,"of patterns"))
	   k <- ntr - 1
	}
	if (k < 1) stop(paste("k =",k,"must be at least 1"))
	clf <- as.factor(cl)
	nc <- max(oldUnclass(clf))
	Z <- .C("VR_knn",
		k, l, ntr, ntr, p, train, oldUnclass(clf), train,
		res = integer(ntr), pr = numeric(ntr), integer(nc+1),
		nc, T, use.all)
	res <- factor(Z$res, levels=seq(along=levels(clf)),labels=levels(clf))
	if(prob) attr(res, "prob") <- Z$pr
	res
}
invisible({
  setInterface("VR_knn1", "C",
               classes = c(rep("integer",3), "numeric", "integer",
                 "numeric", rep("integer",3), "numeric"),
               copy = c(F,F,F,F,F,F,T,F,F,T))
  setInterface("VR_knn", "C",
               classes = c(rep("integer", 5), "numeric", "integer",
                 "numeric", "integer", "numeric", rep("integer", 4)),
               copy = c(F,F,F,F,F,F,F,F,T,T,F,F,F,F))
  })
