# file MASS/truehist.q
# copyright (C) 1994-2002 W. N. Venables and B. D. Ripley
#
"truehist"<-
function(data, nbins = "Scott", h, x0 = -h/1000, breaks,
         prob = T, xlim = range(breaks), ymax = max(est),
	 col = if(is.trellis()) trellis.par.get("bar.fill")$col else 2,
	 xlab = deparse(substitute(data)), bty = "n", ...)
{
    data <- data[!is.na(data)]
    if(missing(breaks)) {
        if(missing(h)) {
            if(is.character(nbins))
                nbins <- switch(casefold(nbins),
                                scott = nclass.scott(data),
                                "freedman-diaconis" = , fd = nclass.fd(data)
                                )
            h <- diff(pretty(data, nbins))[1]
        }
        first <- floor((min(data) - x0)/h)
        last <- ceiling((max(data) - x0)/h)
        breaks <- x0 + h * c(first:last)
    }
    if(any(diff(breaks) <= 0)) stop("breaks must be strictly increasing")
    if(min(data) < min(breaks) || max(data) > max(breaks))
        stop("breaks do not cover the data")
    db <- diff(breaks)
    if(!prob && sqrt(var(db)) > mean(db)/1000)
        warning("Uneven breaks with prob = F will give a misleading plot")
    bin <- cut(data, breaks, include.lowest = T)
    est <- tabulate(bin, length(levels(bin)))
    if(prob) est <- est/(diff(breaks) * length(data))
    n <- length(breaks)
    plot(xlim, c(0, ymax), type = "n", xlab = xlab, ylab = "", bty = bty,
         ...)
    polygon(rbind(breaks[-1], breaks[ - n], breaks[ - n], breaks[-1], NA),
            rbind(0, 0, est, est, NA), col = col, border = 1, ...)
    invisible()
}

is.trellis <- function(device = dev.cur())
  !is.na(match("trellis.settings", names(attributes(.Devices[[device]]))))
