# file MASS/neg.bin.q
# copyright (C) 1994-9 W. N. Venables and B. D. Ripley
#
neg.bin <- function(theta = stop("theta must be given"))
{
  nb.lnk <-
    list(names = "Log: log(mu)",
         link = function(mu) log(mu),
         inverse = function(eta) exp(eta),
         deriv = function(mu) 1/mu,
         initialize = expression(mu <- y + (y == 0)/6))
  nb.var <-
    list(
         names = "mu + mu^2/theta",
         variance = substitute( function(mu, th = .Theta) mu * (1 + mu/th),
           list(.Theta = theta)),
         deviance = substitute(
           function(mu, y, A, residuals = F, th = .Theta)
           {
             devi <- 2 * A * (y * log(pmax(1, y)/mu) -
                              (y + th) * log((y + th)/(mu + th)))
             if(residuals) sign(y - mu) * sqrt(abs(devi))
             else sum(devi)
           }, list(.Theta = theta) )
         )
  make.family("Negative Binomial", link = nb.lnk, variance = nb.var)
}
