# file MASS/isoMDS.q
# copyright (C) 1994-2002 W. N. Venables and B. D. Ripley
#
isoMDS <- function(d, y = cmdscale(d, k), k = 2, maxit = 50, trace = T,
                   tol = 1e-3)
{
    if(any(!is.finite(as.vector(d)))) stop("NAs/Infs not allowed in d")
    if(is.null(n <- attr(d, "Size"))) {
        x <- as.matrix(d)
        if((n <- nrow(x)) != ncol(x))
            stop("Distances must be result of dist or a square matrix")
    } else {
        x <- matrix(0, n, n)
        x[row(x) > col(x)] <- d
        x <- x + t(x)
    }
    if (any(ab <- x[row(x) < col(x)] <= 0)) {
        aa <- cbind(as.vector(row(x)), as.vector(col(x)))[row(x) < col(x),]
        aa <- aa[ab, , drop=F]
        stop(paste("zero or negative distance between objects",aa[1,1],
                   "and", aa[1,2]))
    }
    dis <- x[row(x) > col(x)]
    ord <- order(dis)
    nd <- length(ord)
    if(!is.matrix(y)) stop("y must be a matrix")
    if(any(dim(y) != c(n, k)) ) stop("invalid initial configuration")
    on.exit(.C("VR_mds_unload"))
    .C("VR_mds_init_data",
       nd, k, n, (ord - 1), order(ord) - 1, y,
       CLASSES = c(rep("integer",5), "double"),
       COPY = rep(F,6)
       )
    tmp <- .C("VR_mds_dovm",
              val = double(1), maxit, trace, y = y, tol,
              CLASSES = c("double", "integer", "integer", "double", "double"),
              COPY = c(F, F, F, T, F)
              )
    points <- matrix(tmp$y,,k)
    rn <- if(is.matrix(d)) dimnames(d)[[1]] else names(d)
    dimnames(points) <- list(rn, NULL)
    list(points = points, stress = tmp$val)
}

Shepard <- function(d, x)
{
#
# Given a dissimilarity d and configuration x, compute Shepard plot
#
  n <- nrow(x)
  k <- ncol(x)
  y <- dist(x)
  ord <- order(d)
  y <- y[ord]
  nd <- length(ord)
  Z <- .C("VR_mds_fn",
	  y, yf=y, nd, ssq = double(1), order(ord)-1, x, n, k, n*k, 1,
          CLASSES = c(rep("double", 2), "integer", "double", "integer",
            "double", rep("integer", 2), "double", "integer"),
          COPY = c(F, T, rep(F, 8))
	  )
  list(x = d[ord], y = y, yf = Z$yf)
}

