# file MASS/hist.scott.q
# copyright (C) 1994-9 W. N. Venables and B. D. Ripley
#
nclass.FD <- function(x)
{
    r <- as.vector(quantile(x, c(0.25, 0.75)))
    h <- 2 * (r[2] - r[1]) * length(x)^(-1/3)
    ceiling(diff(range(x))/h)
}

hist.scott <- function(x, prob = T, xlab = deparse(substitute(x)), ...)
   invisible(hist(x, nclass.scott(x), prob=prob, xlab=xlab, ...))
hist.FD <- function(x, prob = T, xlab = deparse(substitute(x)), ...)
   invisible(hist(x, nclass.FD(x), prob=prob, xlab=xlab, ...))

frequency.polygon <- function(x, nclass = nclass.freq(x),
    xlab="", ylab="", ...)
{
    hst <- hist(x, nclass, probability=T, plot=F, ...)
    midpoints <- 0.5 * (hst$breaks[-length(hst$breaks)]
                        + hst$breaks[-1])
    plot(midpoints, hst$counts, type="l", xlab=xlab, ylab=ylab)
}

nclass.freq <- function(x)
{
    h <- 2.15 * sqrt(var(x)) * length(x)^(-1/5)
    ceiling(diff(range(x))/h)
}

