glmmPQL <- function(fixed, random, family, data, correlation, weights,
                    dispersion = NULL,
                    control, niter = 10, verbose = T, ...)
{
    m <- mcall <- Call <- match.call()
    nm <- names(m)[-1]
    keep <- is.element(nm, c("weights", "data", "subset", "na.action"))
    for(i in nm[!keep]) m[[i]] <- NULL
    allvars <-
        if (is.list(random))
            allvars <- c(all.vars(fixed), names(random),
                         unlist(lapply(random, function(x) all.vars(formula(x)))))
        else c(all.vars(fixed), all.vars(random))
    m$formula <- as.formula(paste("~", paste(allvars, collapse="+")))
    m$drop.unused.levels <- T
    m[[1]] <- as.name("model.frame")
    mf <- eval(m, sys.parent())
    off <- model.extract(mf, "offset")
    w <-  model.extract(mf, "weights")
    if(is.null(w)) w <- rep(1, nrow(mf))
    mf$wts <- w
    fit0 <- glm(formula = fixed, family = family, data = mf, weights = wts,
                ..., y = T)
    if(!is.null(neww <- fit0$prior.weights)) w <- neww
    eta <- fit0$linear.predictor - off
    zz <- eta + fit0$residuals
    wz <- fit0$weights
    fam <- as.family(family)

    nm <- names(mcall)[-1]
    keep <- is.element(nm, c("fixed", "random", "data", "subset",
                             "na.action", "control"))
    for(i in nm[!keep]) mcall[[i]] <- NULL
    fixed[[2]] <- Quote(zz)
    mcall[["fixed"]] <- fixed
    mcall[[1]] <- as.name("lme")
    mcall$random <- random
    mcall$method <- "ML"
    if(!missing(correlation))
        mcall$correlation <- correlation
    mcall$weights <- Quote(varFixed(~invwt))
    mf$zz <- zz
    mf$invwt <- 1/wz
    mcall$data <- mf

    if(!is.null(dispersion)) {
        if(!is.null(con <- mcall$control)) {
            if(as.character(con[[1]]) != "lmeControl")
                stop("control arg should be a call to lmeControl")
            else {
                con$sigma <- dispersion
                mcall$control <- con
            }
        } else {
            mcall$control <- substitute(lmeControl(sigma=dispersion),
                                        list(dispersion = dispersion))
        }
    }
    for(i in 1:niter) {
        if(verbose) cat("iteration", i, "\n")
        fit <- eval(mcall)
        etaold <- eta
        ##update zz and invwt
        eta <- fitted(fit)
        if(sum((eta-etaold)^2) < 1e-6*sum(eta^2)) break;
        mu <- fam$inverse(eta)
        mf$zz <- eta + (fit0$y - mu) *  fam$deriv(mu) - off
        wz <- eval(fam$weight)
        mf$invwt <- 1/wz
        mcall$data <- mf
    }
    fit$call <- Call
    fit
}

