# file MASS/data.q
# copyright (C) 1994-2002 W. N. Venables and B. D. Ripley
#
cement <- read.table("data/cement.dat", header=T)
cpus <- read.table("data/cpus.dat", sep=",")
forbes <- read.table("data/forbes.dat", header=T)
hills <- read.table("data/hills.dat", sep="\t", header=T)
road <- read.table("data/road.dat", sep="\t", header=T)
Rubber <- read.table("data/rubber.dat", header=T)
trees <- read.table("data/trees.dat", header=T)
mammals <- read.table("data/mammals.dat",sep="\t", header=T)
ships <- read.table("data/ships.dat", header=T)
mcycle <- read.table("data/mcycle.dat", header=T)
rock <- read.table("data/rock.dat")
rotifer <- read.table("data/rotifer.dat", header=T)
leuk <- read.table("data/leuk.dat")
gehan <- read.table("data/gehan.dat")
motors <- read.table("data/motors.dat", header=T)
painters <- read.table("data/painters.dat", header=T)
shuttle <- read.table("data/shuttle.dat", sep=",", header=T)
wtloss <- read.table("data/wtloss.dat")
cats <- read.table("data/cats.dat")
quine <- read.table("data/quine.dat")
oats <- read.table("data/oats.dat")
immer <- read.table("data/immer.dat")
steam <- read.table("data/steam.dat")
stormer <- read.table("data/stormer.dat")
michelson1 <- read.table("data/michels.dat")
attach(michelson1)
michelson <- data.frame(Speed, Run=factor(Run), Expt=factor(Expt))
invisible(detach())
rm(michelson1)
faithful <- read.table("data/faithful.dat")
galaxies <- scan("data/galaxies.dat")
birthwt <- read.table("data/birthwt.dat")
minn38 <- read.table("data/minn38.dat")
phones <- scan("data/phones.dat",list(year=0, calls=0))
   phones$calls <- 10*phones$calls
Animals <- read.table("data/animals.dat",sep=",", header=T)
crabs <- read.table("data/crabs.dat", header=T)
survey <- read.table("data/survey.dat", sep=",", header=T, row.names=1)
coop <- read.table("data/coop.dat")
Melanoma <- read.table("data/melanoma.dat")
Aids2 <- read.table("data/aids2.dat", header=T)
Tlev <- c("hs", "hsid", "id", "het", "haem",  "blood", "mother", "other")
Aids2 <- data.frame(state=c("NSW", "Other", "QLD", "VIC")[Aids2$state],
   sex=Aids2$sex, diag=Aids2$diag, death=Aids2$death, status=Aids2$status,
   T.categ=factor(Tlev[Aids2$T.categ], levels=Tlev), age=Aids2$age)
rm(Tlev)


abbey <- scan("data/misc.dat", skip=32, n=31)
chem <- scan("data/misc.dat", skip=36, n=24)
newcomb <- scan("data/misc.dat", skip=39, n=66)
shrimp <- scan("data/misc.dat", skip=51, n=18)
DDT <- scan("data/misc.dat", skip=54, n=15)
shoes <- scan("data/misc.dat",list(A=0, B=0), skip=57, n=20)


topo <- read.table("data/topo.dat", header=T)
shkap <- read.table("data/shkap.dat", header=T)
npr1 <- read.table("data/npr.dat")
Rabbit <- read.table("data/Rabbit.dat")
petrol <- read.table("data/petrol.dat")
sitka <- scan("data/Sitka.dat")
Sitka <- data.frame(size = sitka,
           Time = rep(c(152,174,201,227,258), 79),
           tree = rep(1:79, rep(5, 79)),
           treat = rep(c("ozone", "control"), c(54, 25)*5))
rm(sitka)
sitka <- scan("data/Sitka89.dat")
Sitka89 <- data.frame(size = sitka,
           Time = rep(c(469, 496, 528, 556, 579, 613, 639, 674), 79),
           tree = rep(1:79, rep(8, 79)),
           treat = rep(c("ozone", "control"), c(54, 25)*8))
rm(sitka)
Cushings <- read.table("data/Cushings.dat", header=T, row.names=1)
fgl <- read.table("data/fglass.dat")
fgl$type <- factor(fgl$type, labels=c("WinF", "WinNF", "Veh",  "Con", "Tabl", "Head"))
fgl$RI <- 1000*fgl$RI - 1518

beav1 <- read.table("data/beaver1.dat", header=T)
beav2 <- read.table("data/beaver2.dat", header=T)


menarche <- read.table("data/menarche.dat", header=T)
UScereal <- read.table("data/UScereal.dat", header=T, sep=",")
biopsy <- read.table("data/biopsy.dat", sep=",", na.strings="?",header=T)
biopsy$class <- factor(biopsy$class, labels=c("benign", "malignant"))
biopsy$ID <- as.character(biopsy$ID)
gilgais <- read.table("data/gilgais.dat", header=T, row.names=1)
UScrime <- read.table("data/UScrime.dat")
Skye <- read.table("data/Skye.dat", header=T)
GAGurine <- read.table("data/GAGurine.dat")
snails <- read.table("data/snails.dat", header=T)
genotype <- read.table("data/genotype.dat", header=T)
Cars93 <- read.table("data/Cars93.dat", sep=",", header=T)
Traffic <- read.table("data/traffic.dat", header=T)
Insurance <- read.table("data/insur.dat", header=T)
Insurance$Group <- ordered(Insurance$Group,
                           labels=c("<1l", "1-1.5l", "1.5-2l", ">2l"))
Insurance$Age <- ordered(Insurance$Age,
                         labels=c("<25", "25-29", "30-35", ">35"))
Insurance$District <- factor(Insurance$District)
OME <- read.table("data/OME.dat", header=T)
Boston <- read.table("data/Boston.dat", header=T)
synth.te <- read.table("data/synth.te", header=T)
synth.tr <- read.table("data/synth.tr", header=T)
Pima.te <- read.table("data/pima.te", header=T)
Pima.tr <- read.table("data/pima.tr", header=T)
Pima.tr2 <- read.table("data/pima.tr2", header=T)
farms <- read.table("data/farms.dat", header=T)
waders <- read.table("data/waders.dat", header=T)
caith <- read.table("data/Fisher.dat")
npk1 <- read.table("data/npk.dat", header=T)
npk <- data.frame(block=factor(rep(1:6, rep(4,6))),
      N=factor(npk1$N), P=factor(npk1$P), K=factor(npk1$K),
      yield=npk1$yield)
rm(npk1)
cabbages <- read.table("data/cabbage.dat")
whiteside <- read.table("data/Whiteside.dat")
whiteside$Insul <- factor(whiteside$Insul, levels=c("Before", "After"))
anorexia <- read.table("data/anorexia.dat")
housing <- read.table("data/housing.dat")
housing$Sat <- ordered(housing$Sat, levels=c("Low", "Medium", "High"))
housing$Infl <- factor(housing$Infl, levels=c("Low", "Medium", "High"))
housing$Cont <- factor(housing$Cont, levels=c("Low", "High"))
housing$Type <- factor(housing$Type, levels=c("Tower", "Apartment",
                                       "Atrium", "Terrace"))
muscle <- read.table("data/muscle.dat")
eagles <- read.table("data/eagles.dat", header=T)

tmp <- scan("data/austres.dat", what=list(num=0,year=0, mon=""))
if(version$minor==0) {
nottem <- rts(scan("data/nottem.dat"), start=1920, frequency=12)
lh <- rts(scan("data/misc.dat", n=48))
deaths <- rts(scan("data/misc.dat", skip=4, n=72), start=1974, frequency=12)
accdeaths <- rts(scan("data/misc.dat", skip=11, n=72), start=1973, frequency=12)
mdeaths <- rts(scan("data/misc.dat", skip=18, n=72), start=1974, frequency=12)
fdeaths <- rts(scan("data/misc.dat", skip=25, n=72), start=1974, frequency=12)
drivers <- rts(scan("data/drivers.dat"), start=1969, frequency=12)
austres <- rts(tmp$num, start=c(1971,2), freq=4)
invisible()
} else {
nottem <- rts(scan("data/nottem.dat"), start=1920, frequency=12, units="months")
lh <- rts(scan("data/misc.dat", n=48), units="10mins")
deaths <- rts(scan("data/misc.dat", skip=4, n=72), start=1974,
  frequency=12, units="months")
accdeaths <- rts(scan("data/misc.dat", skip=11, n=72), start=1973,
  frequency=12, units="months")
mdeaths <- rts(scan("data/misc.dat", skip=18, n=72), start=1974,
  frequency=12, units="months")
fdeaths <- rts(scan("data/misc.dat", skip=25, n=72), start=1974,
  frequency=12, units="months")
drivers <- rts(scan("data/drivers.dat"), start=1969, frequency=12, units="months")
austres <- rts(tmp$num, start=c(1971,2), freq=4, units="quarters")
invisible()
}
rm(tmp)

# for S-PLUS 5.0 only
if(version$minor==0) {
cancer.vet <- read.table("data/vet.dat", header=T)
invisible()
}

nlschools <- read.table("data/nlschools.dat", header = T)
facs <- c("class", "COMB")
nlschools[facs] <- lapply(nlschools[facs], as.factor)
rm(facs)

epil <- read.table("data/epil.dat", header = T, sep = ",")[, -7]
row.names(epil) <- 1:236
epil$period <- rep(1:4, 59)
epil$lbase <- scale(log(epil$base/4), T, F)[, 1]
epil$lage <- scale(log(epil$age) , T, F)[, 1]
epil$trt <- factor(epil$trt, labels = c("placebo", "progabide"))

bacteria <- read.table("data/bacteria.dat", header = T)
bacteria$trt <- factor(bacteria$trt, levels = c("placebo","drug","drug+"))

source("data/SP500.q")
