# file MASS/biplot.princomp.q
# copyright (C) 1994-9 W. N. Venables and B. D. Ripley
#
biplot.princomp <- function(x, choices = 1:2, scale = 1, pc.biplot=F, ...)
{
    if(length(choices) != 2) stop("length of choices must be 2")
    if(!length(scores <- x$scores))
        stop(paste("object", deparse(substitute(x)), "has no scores"))
    lam <- x$sdev[choices]
    if(is.null(n <- x$n.obs)) n <- 1
    lam <- lam * sqrt(n)
    if(scale < 0 || scale > 1) warning("scale is outside [0, 1]")
    if(scale != 0) lam <- lam^scale else lam <- 1
    if(pc.biplot) lam <- lam / sqrt(n)
    biplot.default(t(t(scores[, choices]) / lam),
                   t(t(x$loadings[, choices]) * lam), ...)
    invisible()
}
