# MASS/modified/deriv3.q copyright (C) 1992 D. M. Smith.
#
"deriv3"<-
function(expr, ...)
UseMethod("deriv3")

"deriv3.default"<-
function(expr, namevec, function.arg = NULL, tag = ".expr", hessian = T)
{
# MASS/modified/deriv3.q copyright (C) 1992 D. M. Smith.
#
# From the original submission to statlib:
#
# A modification to the Aug '91 S function deriv()
# including an option to generate a hessian function suitable for input
# to ms().
#
# This code is based upon the original version of deriv(). Permission is
# granted to redistribute this software provided such an act does not
# violate the terms of the copyright applying to the deriv() code.
#
	max.express <- unlist(options("expressions"))
	if(max.express < 1000) {
		options(expressions = 1000)	# this function is highly recursive

		on.exit(options(expressions = max.express))
	}
	assign("tag", tag, frame = 1)
	assign(".elist", NULL, frame = 1)
	npar <- length(namevec)
	fval <- exprgen(expr)
	ders <- 1:npar
	if(hessian)
		hess <- matrix(NA, nrow = npar, ncol = npar)
	for(i in 1:npar) {
		di <- D(expr, namevec[i])
		if(!(ders[i] <- exprgen(di)))
			ders[i] <- addlist(di)
		if(hessian) {
			for(j in i:npar) {
				dij <- D(di, namevec[j])
				if(!(hess[i, j] <- exprgen(dij)))
					hess[i, j] <- addlist(dij)
				hess[j, i] <- hess[i, j]
			}
		}
	}
	nexpr <- length(.elist)
	.elist <- c(.elist, paste(tag, if(hessian) c(fval, 0, 0, ders, hess)
		 else c(fval, 0, ders), sep = ""))
	nextended <- length(.elist)
	expressions <- parse(text = .elist)
	graddef <- nexpr + 2
	hessdef <- nexpr + 3
	# fold expressions.  Do not fold those used more than once
	nofold <- c(logical(nexpr), rep(T, npar + 2 + if(hessian) npar^2 + 1
		 else 0))
	nofold <- nofold | apply(outer(all.names(expressions), paste(tag, 1:
		nextended, sep = ""), "=="), 2, sum) > 1
	parentemplate <- expression((a))[[1]]
	for(i in (1:nexpr)[!nofold]) {
		thisname <- paste(tag, i, sep = "")
		subst <- parentemplate
		subst[[2]] <- expressions[i][[1]]
		for(j in (i + 1):nextended) {
			if(match(thisname, all.names(expressions[j]), 0)) {
				thisexpr <- expressions[j][[1]]
				if(is.name(thisexpr))
					thisexpr <- subst[[2]]
				else for(k in 1:length(thisexpr))
						if(is.name(thisexpr[[k]]) &&
							thisexpr[[k]] ==
							thisname) thisexpr[[
								k]] <- subst
				expressions[j][[1]] <- thisexpr
				break
			}
		}
	}
	nams <- c(paste(tag, 1:nexpr, sep = ""), ".value", ".grad", if(hessian
		) ".hess", paste(".grad[ ,\"", namevec, "\"]", sep = ""), if(
		hessian) paste(".hess[,", outer(namevec, namevec, function(s1,
			s2)
		paste("\"", s1, "\",\"", s2, "\"", sep = "")), "]", sep = ""))
	out <- parse(text = c("{", paste(nams, "<-", 0, sep = ""), "}"))
	body <- out[[1]]
	for(i in (1:nextended)[nofold])
		body[[i]][[2]] <- expressions[i][[1]]
	body[[graddef]][[2]] <- parse(text = c("array(0,c(length(.value),",
		npar, "),list(NULL,", deparse(namevec), "))"))[[1]]
	if(hessian)
		body[[hessdef]][[2]] <- parse(text = c(
			"array(0,c(length(.value),", npar, ",", npar,
			"),list(NULL,", deparse(namevec), ",", deparse(namevec),
			"))"))[[1]]
	body <- body[nofold]
	added <- parse(text = c("attr(.value,\"gradient\") <- .grad", if(
		hessian) "attr(.value,\"hessian\") <- .hess", ".value"))
	body <- c(body, added)
	mode(body) <- "{"
	if(length(function.arg)) {
		if(is.function(function.arg))
			value <- function.arg
		else if(is.recursive(function.arg)) {
			value <- vector("expression", length(function.arg) +
				1)
			value[ - length(value)] <- function.arg
		}
		else {
			value <- vector("expression", length(function.arg) +
				1)
			names(value) <- c(as.character(function.arg), "")
		}
		mode(value) <- "function"
		value[[length(value)]] <- body
		value
	}
	else {
		out[[1]] <- body
		out
	}
}

"deriv3.formula"<-
function(expr, namevec, function.arg = NULL, tag = ".expr", hessian = T)
{
# MASS/modified/deriv3.q copyright (C) 1992 D. M. Smith.
#
# From the original submission to statlib:
#
# A modification to the Aug '91 S function deriv()
# including an option to generate a hessian function suitable for input
# to ms().
#
# This code is based upon the original version of deriv(). Permission is
# granted to redistribute this software provided such an act does not
# violate the terms of the copyright applying to the deriv() code.
#
	expr <- expr[[length(expr)]]
	NextMethod("deriv3")
}
