library(MASS)
library(rpart)
set.seed(123)

# cpus is a dataset on mainframe performance
?cpus  # for information on it

cpus.rp <- rpart(log10(perf) ~ ., cpus[ , 2:8], cp = 1e-3)
cpus.rp  # gives a large tree
print(cpus.rp, cp = 0.01)

plot(cpus.rp, uniform = T)
text(cpus.rp, digits = 3)

ir.rp <- rpart(Species ~ ., data = ird, cp = 1e-3)
ir.rp

plotcp(cpus.rp)

print(cpus.rp, cp = 0.006, digits = 3)
cpus.rp1 <- prune(cpus.rp, cp = 0.006)
plot(cpus.rp1, branch = 0.4, uniform = T)
text(cpus.rp1, digits = 3)

printcp(ir.rp)

summary(ir.rp)

## Forensic glass

set.seed(123)
fgl.rp <- rpart(type ~ ., fgl, cp = 0.001)
plotcp(fgl.rp)
printcp(fgl.rp)
print(fgl.rp, cp=0.02)

fgl.rp2 <- prune(fgl.rp, cp = 0.02)
plot(fgl.rp2, uniform = T)
text(fgl.rp2, use.n = T)
