library(SDM)
library(MASS)
library(class)

attach(synth.tr)

x <- seq(-1.24,1, 0.04)
y <- seq(-0.2,1.1,0.02)
eqscplot(xs, ys, type="n", xlim=c(-1.25, 1), xlab="", ylab="")
contour(x,y,log(p1val)-log(p0val), levels=0, labex=0, add=T)
points(xs[1:125], ys[1:125], pch=16, col=6, cex=0.5)
points(xs[126:250], ys[126:250], pch=16, col=8, cex=0.5)

xT <- cbind(xs, ys)
XT <- expand.grid(x, y)
d0 <- knn1d(cbind(xs, ys)[yc==0,] , XT, yc[yc==0])
d1 <- knn1d(cbind(xs, ys)[yc==1,] , XT, yc[yc==1])
contour(x,y , matrix(d1 - d0,length(x)), levels=0, labex=0, add=T, col=2)

xTm <- multiedit(xT, yc)
synthm <- synth.tr[xTm, ]
attach(synthm)
eqscplot(synth.tr$xs, synth.tr$ys, type="n", xlim=c(-1.25, 1))
contour(x, y, log(p1val)-log(p0val), levels=0, labex=0, add=T)
points(xs[yc==0], ys[yc==0],  pch=16, col=6, cex=0.5)
points(xs[yc==1], ys[yc==1],  pch=16, col=8, cex=0.5)
# a one-off trick to enable us to contour the boundary
d0 <- knn1d(cbind(xs, ys)[yc==0,] , XT, yc[yc==0])
d1 <- knn1d(cbind(xs, ys)[yc==1,] , XT, yc[yc==1])
contour(x,y , matrix(d1 - d0,length(x)), levels=0, labex=0, add=T, col=2)
detach()

cvs <- knn.cv(xT, yc, 10, 9)
keep <- cvs==yc
keep[is.na(keep)] <- F

eqscplot(synth.tr$xs, synth.tr$ys, type="n", xlim=c(-1.25, 1))
contour(x, y, log(p1val)-log(p0val), levels=0, labex=0, add=T)
synthp <- synth.tr[keep, ]
synthp <- synth.tr[keep, ]
attach(synthp)
points(xs[yc==0], ys[yc==0], pch=16, col=6, cex=0.5)
points(xs[yc==1], ys[yc==1], pch=16, col=8, cex=0.5)
d0 <- knn1d(cbind(xs, ys)[yc==0,] , XT, yc[yc==0])
d1 <- knn1d(cbind(xs, ys)[yc==1,] , XT, yc[yc==1])
contour(x,y , matrix(d1 - d0,length(x)), levels=0, labex=0,  add=T, col=2)
detach()


attach(synthm)
set.seed(777)
cset <- condense(cbind(xs, ys), yc)
synthc <- synthm[cset, ]
attach(synthc)
eqscplot(synth.tr$xs, synth.tr$ys, type="n", xlim=c(-1.25, 1))
contour(x, y, log(p1val)-log(p0val), levels=0, labex=0, add=T)
points(xs[yc==0], ys[yc==0], pch=16, col=6, cex=0.5)
points(xs[yc==1], ys[yc==1], pch=16, col=8, cex=0.5)
d0 <- knn1d(cbind(xs, ys)[yc==0,] , XT, yc[yc==0])
d1 <- knn1d(cbind(xs, ys)[yc==1,] , XT, yc[yc==1])
contour(x,y , matrix(d1 - d0,length(x)), levels=0, labex=0,
        add=T, col=2)
detach()


rset <- reduce.nn(cbind(xs, ys), cset, yc)
synthr <- synthm[rset, ]
attach(synthr)
eqscplot(synth.tr$xs, synth.tr$ys, type="n", xlim=c(-1.25, 1))
contour(x,y,log(p1val)-log(p0val), levels=0, labex=0, add=T)
points(xs[yc==0], ys[yc==0], pch=16, col=6, cex=0.5)
points(xs[yc==1], ys[yc==1], pch=16, col=8, cex=0.5)
d0 <- knn1d(cbind(xs, ys)[yc==0,] , XT, yc[yc==0])
d1 <- knn1d(cbind(xs, ys)[yc==1,] , XT, yc[yc==1])
contour(x,y , matrix(d1 - d0,length(x)), levels=0, labex=0,
        add=T, col=2)
detach()

# now start from the full set
attach(synthr)
cset0 <- condense(cbind(xs, ys), yc)
rset0 <- reduce.nn(cbind(xs, ys), cset0, yc)
synthr0 <- synth.tr[rset0, ]
attach(synthr0)
eqscplot(synth.tr$xs, synth.tr$ys, type="n", xlim=c(-1.25, 1))
contour(x, y, log(p1val)-log(p0val), levels=0, labex=0, add=T)
points(xs[yc==0], ys[yc==0], pch=16, col=6, cex=0.5)
points(xs[yc==1], ys[yc==1], pch=16, col=8, cex=0.5)
d0 <- knn1d(cbind(xs, ys)[yc==0,] , XT, yc[yc==0])
d1 <- knn1d(cbind(xs, ys)[yc==1,] , XT, yc[yc==1])
contour(x,y , matrix(d1 - d0,length(x)), levels=0, labex=0,
        add=T, col=2)
detach()


# k-NN on Cushings'

par(pty="s", mfrow=c(1,2))
cush <- log(as.matrix(Cushings[1:21, -3]))
tp <- factor(Cushings$Type[1:21])
xp <- seq(0.6, 4.0, length=100); np <- length(xp)
yp <- seq(-3.25, 2.45, length=100)
cushT <- expand.grid(Tetrahydrocortisone=xp,
     Pregnanetriol=yp)

plot(Cushings[,1], Cushings[,2], log="xy", type="n",
     xlab = "Tetrahydrocortisone", ylab = "Pregnanetriol",
     main = "1-NN")
text(Cushings[1:21,1], Cushings[1:21,2],
     labels = as.character(tp))
text(Cushings[22:27,1], Cushings[22:27,2], labels = "u")
Z <- knn(scale(cush, F, c(3.4, 5.7)),
         scale(cushT, F, c(3.4, 5.7)), tp)
contour(xp/log(10), yp/log(10), matrix(as.numeric(Z=="a"), np),
      add=T, levels=0.5, labex=0)
contour(xp/log(10), yp/log(10), matrix(as.numeric(Z=="c"), np),
      add=T, levels=0.5, labex=0)
plot(Cushings[,1], Cushings[,2], log="xy", type="n",
     xlab="Tetrahydrocortisone", ylab = "Pregnanetriol",
     main = "3-NN")
text(Cushings[1:21,1], Cushings[1:21,2],
     labels = as.character(tp))
text(Cushings[22:27,1], Cushings[22:27,2], labels = "u")
Z <- knn(scale(cush, F, c(3.4, 5.7)),
         scale(cushT, F, c(3.4, 5.7)), tp, k=3)
contour(xp/log(10), yp/log(10), matrix(as.numeric(Z=="a"), np),
      add=T, levels=0.5, labex=0)
contour(xp/log(10), yp/log(10), matrix(as.numeric(Z=="c"), np),
      add=T, levels=0.5, labex=0)
par(mfrow=c(1,1), pty="m")

# LVQ on synthetic

attach(synth.tr)
cd1 <- lvqinit(xT, yc, 4)
eqscplot(xs, ys, type="n", xlim=c(-1.25, 1), xlab="", ylab="")
contour(x,y,log(p1val)-log(p0val), levels=0, labex=0, add=T)
points(cd1$x[cd1$cl==0,], pch=1, col=6)
points(cd1$x[cd1$cl==1,], pch=1, col=8)

cd2 <- olvq1(xT, yc, cd1)
points(cd2$x, pch=3, mkh=0, cex=2)
cd3 <- lvq2(xT, yc, cd2, 25000)
points(cd3$x[cd3$cl==0,], pch=2, col=6)
points(cd3$x[cd3$cl==1,], pch=2, col=8)


cd1 <- lvqinit(xT, yc, 10)
eqscplot(xs, ys, type="n", xlim=c(-1.25, 1), xlab="", ylab="")
contour(x,y,log(p1val)-log(p0val), levels=0, labex=0, add=T)
points(cd1$x, pch=1)

cd2 <- olvq1(xT, yc, cd1)
points(cd2$x, pch=3, mkh=0, cex=2)
cd3 <- lvq3(xT, yc, cd2, 25000)
attach(cd3)
d0 <- knn1d(cd3$x[cl==0,] , XT, cl[cl==0])
d1 <- knn1d(cd3$x[cl==1,] , XT, cl[cl==1])
contour(x, y, matrix(d1 - d0,length(x)), levels=0, labex=0, add=T, lty=3)
points(cd3$x, pch=2)
detach()

cd1 <- lvqinit(xT, yc, 30)
eqscplot(xs, ys, type="n", xlim=c(-1.25, 1), xlab="", ylab="")
contour(x,y,log(p1val)-log(p0val), levels=0, labex=0, add=T)
cd2 <- olvq1(xT, yc, cd1)
points(cd2$x, pch=3, mkh=0, cex=1.5)
attach(cd2)
d0 <- knn1d(cd2$x[cl==0,] , XT, cl[cl==0])
d1 <- knn1d(cd2$x[cl==1,] , XT, cl[cl==1])
contour(x,y , matrix(d1 - d0,length(x)), levels=0, labex=0,
	     add=T, col=2)
detach()

attach(synthm)
cd1 <- list(x=cbind(xs, ys)[cset,], cl = yc[cset])
detach()
cd2 <- olvq1(cbind(xs, ys), yc, cd1)
eqscplot(xs, ys, type="n", xlim=c(-1.25, 1), xlab="", ylab="")
contour(x,y,log(p1val)-log(p0val), levels=0, labex=0, add=T)
points(cd2$x, pch=3, mkh=0, cex=2)
detach()



# Forensic glass
set.seed(123); rand <- sample (10, 214, replace=T)
con <- function(x,y)
{
   tab <- table(x,y)
   print(tab)
   diag(tab) <- 0
   cat("error rate = ", round(100*sum(tab)/length(x),2),"%\n")
   invisible()
}

fgl0 <- fgl[ ,-10] # drop type
{ res <- fgl$type
  for (i in sort(unique(rand))) {
     cat("fold ",i,"\n", sep="")
     sub <- rand == i
     res[sub] <- knn(fgl0[!sub, ], fgl0[sub,], fgl$type[!sub], k=1)
  }
  res } -> res.knn1
con(fgl$type, res.knn1)

res.lb <- knn(fgl0, fgl0, fgl$type, k=3, prob=T, use.all=F)
tt <- table(attr(res.lb, "prob"))
as.vector(1/3 * tt[2])/nrow(fgl0)

cd0 <- lvqinit(fgl0, fgl$type, prior=rep(1,6)/6,k=3)
cd1 <- olvq1(fgl0, fgl$type, cd0)
con(fgl$type, lvqtest(cd1, fgl0))

# try other strategies here too
CV.lvq <- function()
{
  res <- fgl$type
  for(i in sort(unique(rand))) {
    cat("doing fold",i,"\n")
    cd0 <- lvqinit(fgl0[rand != i,], fgl$type[rand != i],
                   prior=rep(1,6)/6, k=3)
    cd1 <- olvq1(fgl0[rand != i,], fgl$type[rand != i], cd0)
    cd1 <- lvq3(fgl0[rand != i,], fgl$type[rand != i],
                cd1, niter=10000)
    res[rand == i] <- lvqtest(cd1, fgl0[rand == i,])
  }
  res
}
con(fgl$type, CV.lvq())

# Try Mahalanobis distance
fgl0 <- scale(princomp(fgl[,-10])$scores)
con(fgl$type, CV.lvq())
