ggobipath <- "c:/packages/ggobi/ggobi.exe"

ggobi <-
    function(matrx, collab = dimnames(matrx)[[2]],
             rowlab = dimnames(matrx)[[1]], colors = NULL, glyphs = NULL,
             erase = NULL, lines = NULL, linecolors = NULL, resources = NULL,
             vgroups = NULL,
             multi = FALSE)
{
    if(!missing(matrx)) {

        ### data matrix ###
        x <- eval(matrx)
        if(sum(abs(x[!is.na(x)])) == Inf > 0) {
            cat("Sorry, xgobi can't handle Infs\n")
            return()
        }
        tpath <- getenv("S_TMP")
        if(nchar(tpath) == 0)
            tpath <- getenv("TEMP")
        dfile <- paste(tpath, tempfile("xgobi"), sep = "/")
        dfiledat <- paste(dfile, ".dat", sep = "")
        write(t(x), file = dfiledat, ncolumns = ncol(x))
        on.exit(unlink(dfiledat))

        ### Column labels ###
        if(missing(collab)) collab <- dimnames(x)[[2]] else {
                                        # check data type
            if(!is.vector(collab) || !is.character(collab)) {
                cat("The 'collab' argument needs to be a character vector\n"
                    )
                return()
            }
        }
        if(length(collab) > 0) {
            colfile <- paste(dfile, ".col", sep = "")
            cat(collab, file = colfile, sep = "\n")
            on.exit(unlink(colfile), add = T)
        }

        ### Row labels ###
        if(missing(rowlab)) rowlab <- dimnames(x)[[1]] else {
                                        # check data type
            if(!is.vector(rowlab) || !is.character(rowlab)) {
                cat("The 'rowlab' argument needs to be a character vector\n"
                    )
                return()
            }
        }
        if(length(rowlab) > 0) {
            rowfile <- paste(dfile, ".row", sep = "")
            cat(rowlab, file = rowfile, sep = "\n")
            on.exit(unlink(rowfile), add = T)
        }

        ### Colors ###
        if(!missing(colors)) {
            colorfile <- paste(dfile, ".colors", sep = "")
            cat(colors, file = colorfile, sep = "\n")
            on.exit(unlink(colorfile), add = T)
        }

        ### Glyphs ###
        if(!missing(glyphs)) {
                                        # check data type
            if(!is.vector(glyphs) || !is.numeric(glyphs)) {
                cat("The 'glyphs' argument needs to be a numeric vector\n")
                return()
            }
            glyphfile <- paste(dfile, ".glyphs", sep = "")
            cat(glyphs, file = glyphfile, sep = "\n")
            on.exit(unlink(glyphfile), add = T)
        }

        ### Erase ###
        if(!missing(erase)) {
                                        # check data type
            if(!is.vector(erase) || !is.numeric(erase)) {
                cat("The 'erase' argument needs to be a numeric vector\n")
                return()
            }
            erasefile <- paste(dfile, ".erase", sep = "")
            cat(erase, file = erasefile, sep = "\n")
            on.exit(unlink(erasefile), add = T)
        }

        ### Connected lines ###
        if(!missing(lines)) {
                                        # check data type
            if(!is.matrix(lines) || !is.numeric(lines) || dim(lines)[2] !=
               2) {
                cat("The 'lines' argument must be a numeric 2-column matrix\n"
                    )
                return()
            }
            linesfile <- paste(dfile, ".lines", sep = "")
            if(!access(linesfile))
                unlink(linesfile)
            if(nrow(lines) > 0) {
                for(i in 1:nrow(lines))
                    cat(lines[i,  ], "\n", file = linesfile, append
                        = T)
            }
            on.exit(unlink(linesfile), add = T)

            ### Line colors ###
            if(!missing(linecolors)) {
                                        # check data type
                if(!is.vector(linecolors) || !is.character(linecolors))
                {
                    cat("The 'linecolors' argument must be a character vector\n"
                        )
                    return()
                }
                linecolorfile <- paste(dfile, ".linecolors", sep = "")
                cat(linecolors, file = linecolorfile, sep = "\n")
                on.exit(unlink(linecolorfile), add = T)
            }
        }

        ### Resources ###
        if(!missing(resources)) {
                                        # check data type
            if(!is.vector(resources) || !is.character(resources)) {
                cat("The 'resources' argument must be a character vector\n")
                return()
            }
            resourcefile <- paste(dfile, ".resources", sep = "")
            cat(resources, file = resourcefile, sep = "\n")
            on.exit(unlink(resourcefile), add = T)
        }
        command <- paste(ggobipath, dfile)
        cat(command, "\n")
        if(multi) {
            invisible(dos(command, multi = T, minimized = T, output.to.S = F,
                          translate = T))
            ## wait 5 seconds to allow ggobi to start and read its files.
            cat("waiting to allow ggobi to start...\n")
            .p <- proc.time()
            while(proc.time() < .p + 5) {
            }
        }
        else {
            invisible(dos(command, multi = F, minimized = T, output.to.S = F,
                          translate = T))
        }
    }
    else cat("Matrix argument required\n")
}
