library(MASS)
library(nnet)
xgobipath <- "c:/packages/xgobi"

data.restore("LTables/LT.dmp")
virus <- read.table("viruses.dat")
virus$type <- factor(c(rep("Hodr", 3), rep("Tobr", 6), rep("Toba", 39), rep("Furo", 13)), levels=c("Hodr",  "Tobr", "Toba", "Furo"))

CVnn.cpus <- function(formula, data=cpus1[cpus.samp, ],
    size = c(0, 4, 4, 10, 10),
    lambda = c(0, rep(c(0.003, 0.01), 2)),
    nreps = 5, nifold = 10, ...)
{
  CVnn1 <- function(formula, data, nreps=1, ri,  ...)
  {
    truth <- log10(data$perf)
    res <- numeric(length(truth))
    cat("  fold")
    for (i in sort(unique(ri))) {
      cat(" ", i,  sep="")
      for(rep in 1:nreps) {
        learn <- nnet(formula, data[ri !=i,], trace=F, ...)
        res[ri == i] <- res[ri == i] +
                        predict(learn, data[ri == i,])
      }
    }
    cat("\n")
    sum((truth - res/nreps)^2)
  }
  choice <- numeric(length(lambda))
  ri <- sample(nifold, nrow(data), replace=T)
  for(j in seq(along=lambda)) {
    cat("  size =", size[j], "decay =", lambda[j], "\n")
    choice[j] <- CVnn1(formula, data, nreps=nreps, ri=ri,
                       size=size[j], decay=lambda[j], ...)
    }
  cbind(size=size, decay=lambda, fit=sqrt(choice/100))
}

predplot <- function(object, main="", len=100, ...)
{
   plot(Cushings[,1], Cushings[,2], log="xy", type="n",
     xlab="Tetrahydrocortisone", ylab = "Pregnanetriol", main=main)
   for(il in 1:4) {
     set <- Cushings$Type==levels(Cushings$Type)[il]
     text(Cushings[set, 1], Cushings[set, 2],
          labels=as.character(Cushings$Type[set]), col = 2 + il) }
   xp <- seq(0.6, 4.0, length=len)
   yp <- seq(-3.25, 2.45, length=len)
   cushT <- expand.grid(Tetrahydrocortisone=xp,
     Pregnanetriol=yp)
   Z <- predict(object, cushT, ...); zp <- as.numeric(Z$class)
   zp <- Z$post[,3] - pmax(Z$post[,2], Z$post[,1])
   contour(xp/log(10), yp/log(10), matrix(zp, len),
     add=T, levels=0, labex=0)
   zp <- Z$post[,1] - pmax(Z$post[,2], Z$post[,3])
   contour(xp/log(10), yp/log(10), matrix(zp, len),
     add=T, levels=0, labex=0)
   invisible()
}

cush <- log(as.matrix(Cushings[, -3]))
tp <- factor(Cushings$Type[1:21])
Cf <- data.frame(tp = tp,
   Tetrahydrocortisone = log(Cushings[1:21,1]),
   Pregnanetriol = log(Cushings[1:21,2]) )
cush <- cush[1:21,]; tpi <- class.ind(tp)

pltnn <- function(...)
{
  plot(Cushings[, 1], Cushings[, 2], log = "xy", type = "n", xlab =
       "Tetrahydrocortisone", ylab = "Pregnanetriol", ...)
  for(il in 1:4) {
    set <- Cushings$Type == levels(Cushings$Type)[il]
    text(Cushings[set, 1], Cushings[set, 2],
         as.character(Cushings$Type[set]), col = 2 + il)
  }
}

plt.bndry <- function(size = 0, decay = 0, ...)
{
  cush.nn <- nnet(cush, tpi, skip = T, softmax = T, size = size,
                  decay = decay, maxit = 1000)
  invisible(b1(predict(cush.nn, cushT), ...))
}

b1 <- function(Z, ...)
{
  zp <- Z[, 3] - pmax(Z[, 2], Z[, 1])
  contour(xp/log(10), yp/log(10), matrix(zp, np), add = T, levels =
          0, labex = 0, ...)
  zp <- Z[, 1] - pmax(Z[, 3], Z[, 2])
  contour(xp/log(10), yp/log(10), matrix(zp, np), add = T, levels =
          0, labex = 0, ...)
}

p0 <- function(x,y){
	d <- (x - 0.4)^2 + (y - 0.7)^2
	p <- exp(-d/f)
	d <- (x + 0.3)^2 + (y - 0.7)^2
	q <- exp(-d/f)
	(p+q)/(2*f*pi)
}
p1 <- function(x,y){
	d <- (x + 0.7)^2 + (y - 0.3)^2
	p <- exp(-d/f)
	d <- (x - 0.3)^2 + (y - 0.3)^2
	q <- exp(-d/f)
	(p+q)/(2*f*pi)
}
p0val <- matrix(0,57,66)
p1val <- matrix(0,57,66)
x <- seq(-1.24,1, 0.04)
y <- seq(-0.2,1.1,0.02)
f <- 0.06
for(i in 1:66) p0val[,i] <- p0(x, y[i])
for(i in 1:66) p1val[,i] <- p1(x, y[i])

synth.set <- function()
{
  x <- seq(-1.24,1, 0.04)
  y <- seq(-0.2,1.1,0.02)
  attach(synth.tr)
  eqscplot(range(x),range(y),type="n")
  contour(x,y,log(p1val)-log(p0val), add=T, levels=0, labex=0, col=2)
  points(xs[1:125], ys[1:125], col=6,cex=0.5, pch=16)
  points(xs[126:250],ys[126:250],col=8,cex=0.5, pch=16)
  detach()
  invisible("Synth set up")
}


synth.fit <- function(col=4, skip=T, ...)
{
  fit <- nnet(yc ~ xs + ys, data=synth.tr, trace=F, skip=skip, ...)
  print(fit@value)
  XTest <- expand.grid(xs=seq(-1.24,1, 0.04), ys=seq(-0.2,1.1,0.02))
  pred <- predict(fit, XTest)
  prf <- predict(fit, synth.te)
  contour(seq(-1.24,1, 0.04), seq(-0.2,1.1,0.02),matrix(pred,57,66),
          add=T, levels=0.5, labex=0, col=col)
  err <- sum((prf > 0.5) != (synth.te$yc == 1))/10
  cat("\nError rate:", err,"%\n\n")
  invisible()
}

synth.aver <- function(naver=25, col=3, skip=T, ...)
{
  pred <- matrix(0, 57, 66)
  XTest <- expand.grid(xs=seq(-1.24,1, 0.04), ys=seq(-0.2,1.1,0.02))
  for(i in 1:naver) {
	 cat(" ", i)
    fit <- nnet(yc ~ xs + ys, data=synth.tr, trace=F, skip=skip, ...)
    pred1 <- predict(fit, XTest)
    pred <- pred + matrix(pred1,57,66)
    contour(seq(-1.24,1, 0.04), seq(-0.2,1.1,0.02), matrix(pred1,57,66),
            add=T, levels=0.5, labex=0, col=2)
#    guiLocator(0)
  }
  contour(seq(-1.24,1, 0.04), seq(-0.2,1.1,0.02), pred, add=T,
          levels=0.5*naver, labex=0, col=col, lwd=3)
  invisible()
}

ird <- data.frame(rbind(iris[,,1], iris[,,2],iris[,,3]),
           Species=c(rep("s",50), rep("c",50), rep("v",50)))


xgobi <-
  function(matrx,
           collab = dimnames(matrx)[[2]],
           rowlab = dimnames(matrx)[[1]],
           colors = NULL,
           glyphs = NULL,
           erase = NULL,
           lines = NULL,
           linecolors = NULL,
           resources = NULL,
           title = NULL,
           vgroups = NULL,
           nlinkable = NULL,
           subset = NULL,
           display = NULL,
           multi = FALSE)
{
    if(!missing(matrx)) {
        ### data matrix ###
        x <- eval(matrx)
        if (sum(abs(x[!is.na(x)])) == Inf > 0) {
            cat("Sorry, xgobi can't handle Infs\n")
            return()
        }
        tpath <- getenv("S_TMP")
        if(nchar(tpath) == 0) tpath <- getenv("TEMP")
        dfile <- paste(tpath, tempfile("xgobi"), sep = "/")
        write(t(x), file = dfile, ncolumns = ncol(x))
        on.exit(unlink(dfile))

        ### Column labels ###
        if(missing(collab))
            collab <- dimnames(x)[[2]]
        else {
            # check data type
            if(!is.vector(collab) || !is.character(collab)) {
                cat("The 'collab' argument needs to be a character vector\n")
                return()
            }
        }
        if(length(collab) > 0) {
            colfile <- paste(dfile, ".col", sep = "")
            cat(collab, file = colfile, sep = "\n")
            on.exit(unlink(colfile), add = T)
        }

        ### Row labels ###
        if(missing(rowlab))
            rowlab <- dimnames(x)[[1]]
        else {
            # check data type
            if(!is.vector(rowlab) || !is.character(rowlab)) {
                cat("The 'rowlab' argument needs to be a character vector\n")
                return()
            }
        }
        if(length(rowlab) > 0) {
            rowfile <- paste(dfile, ".row", sep = "")
            cat(rowlab, file = rowfile, sep = "\n")
            on.exit(unlink(rowfile), add = T)
        }

        ### Variable groups ###
        if(!missing(vgroups)) {
            # check data type
            if(!is.vector(vgroups) || !is.numeric(vgroups)) {
                cat("The 'vgroups' argument needs to be a numeric vector\n")
                return()
            }
            vgroupfile <- paste(dfile, ".vgroups", sep = "")
            cat(vgroups, file = vgroupfile, sep = "\n")
            on.exit(unlink(vgroupfile), add = T)
        }

        ### Colors ###
        if(!missing(colors)) {
            # check data type
            if(!is.vector(colors) || !is.character(colors)) {
                cat("The 'colors' argument needs to be a character vector\n")
                return()
            }
            colorfile <- paste(dfile, ".colors", sep = "")
            cat(colors, file = colorfile, sep = "\n")
            on.exit(unlink(colorfile), add = T)
        }

        ### Glyphs ###
        if(!missing(glyphs)) {
            # check data type
            if(!is.vector(glyphs) || !is.numeric(glyphs)) {
                cat("The 'glyphs' argument needs to be a numeric vector\n")
                return()
            }
            glyphfile <- paste(dfile, ".glyphs", sep = "")
            cat(glyphs, file = glyphfile, sep = "\n")
            on.exit(unlink(glyphfile), add = T)
        }

        ### Erase ###
        if(!missing(erase)) {
            # check data type
            if(!is.vector(erase) || !is.numeric(erase)) {
                cat("The 'erase' argument needs to be a numeric vector\n")
                return()
            }
            erasefile <- paste(dfile, ".erase", sep = "")
            cat(erase, file = erasefile, sep = "\n")
            on.exit(unlink(erasefile), add = T)
        }

        ### Connected lines ###
        if(!missing(lines)) {
            # check data type
            if(!is.matrix(lines) || !is.numeric(lines) || dim(lines)[2] != 2) {
                cat("The 'lines' argument must be a numeric 2-column matrix\n")
                return()
            }

            linesfile <- paste(dfile, ".lines", sep = "")
            if(!access(linesfile)) unlink(linesfile)
            if(nrow(lines) > 0) {
                for(i in 1:nrow(lines))
                    cat(lines[i,  ], "\n", file = linesfile, append = T)
            }
            on.exit(unlink(linesfile), add = T)

            ### Line colors ###
            if(!missing(linecolors)) {
                # check data type
                if(!is.vector(linecolors) || !is.character(linecolors)) {
                    cat("The 'linecolors' argument must be a character vector\n")
                    return()
                }
                linecolorfile <- paste(dfile, ".linecolors", sep = "")
                cat(linecolors, file = linecolorfile, sep = "\n")
                on.exit(unlink(linecolorfile), add = T)
            }
        }

        ### Resources ###
        if(!missing(resources)) {
            # check data type
            if(!is.vector(resources) || !is.character(resources)) {
                cat("The 'resources' argument must be a character vector\n")
                return()
            }
            resourcefile <- paste(dfile, ".resources", sep = "")
            cat(resources, file = resourcefile, sep = "\n")
            on.exit(unlink(resourcefile), add = T)
        }

        ### nlinkable ###
        if(!missing(nlinkable)) {
            # check data type
            nlinkable <- as.integer(nlinkable)
            if(length(nlinkable) > 1) {
                cat("The 'nlinkable' argument must be a scalar integer\n")
                return()
            }
            linkablefile <- paste(dfile, ".nlinkable", sep = "")
            cat(nlinkable, "\n", file = linkablefile)
            on.exit(unlink(linkablefile), add = T)
        }
        ### subset ###
        subsetarg <- ""
        if (!missing(subset)) {
            # check data type
            subset <- as.integer(subset)
            if (length(subset) > 1) {
                cat("The 'subset' argument must be a scalar integer\n")
                return()
            }
            else if (subset == 0 || subset > nrow(x)) {
                cat("The 'subset' argument must be >0 and <= nrows\n")
                return()
            }
            subsetarg <- paste(" -subset ", subset, sep="")
        }
        args <- ""
        if (subsetarg != "") args <- subsetarg

        if (!missing(display)) {
            if (!is.character(display))
                warning("display must be a character string")
            else args <- paste("-display", display, args)
        }

        if (!missing(title)) {
            if (!is.character(title)) {
                warning("title must be a character string")
                title <- deparse(substitute(matrx))
            }
        }
        else title <- deparse(substitute(matrx))
        args <- paste("-vtitle", paste("'", title, "'", sep=""), args)

        # Note to installer:
        # Here you need to specify the path to the xgobi batch file/ executable
        # on your system.
        #
        xgobipath <- paste(xgobipath, "xgobi.bat", sep="/")
        command <- paste(xgobipath, args, dfile)
        cat(command, "\n")
        if(multi) {
            invisible(dos(command, multi = T, minimized = T,
                          output.to.S = F, translate = T))
            ## wait 5 seconds to allow xgobi to start and read its files.
            cat("waiting to allow xgobi to start...\n")
            .p <- proc.time()
            while(proc.time() < .p + 5) {}
        } else {
            invisible(dos(command, multi = F, minimized = T,
                          output.to.S = F, translate = T))
        }
    }
    else cat("Matrix argument required\n")
}

xgvis <-
  function(dmat       = NULL,
           edges      = NULL,
           pos        = NULL,
           rowlab     = NULL,
           colors     = NULL,
           glyphs     = NULL,
           erase      = NULL,
           lines      = NULL,
           linecolors = NULL,
           resources  = NULL,
           display    = NULL,
           multi      = FALSE)
{
    if (missing(edges) && missing(pos) && missing(dmat)) {
        cat("One of dmat, edges, or pos must be present\n")
        return()
    }

    tpath <- getenv("S_TMP")
    if(nchar(tpath) == 0) tpath <- getenv("TEMP")
    basefile <- paste(tpath, tempfile("xgvis"), sep = "/")

    ### distance matrix ###
    if (!missing(dmat)) {
        dmat <- eval(dmat)
        if (sum(abs(dmat[!is.na(dmat)])) == Inf > 0) {
            cat("xgvis can't handle Infs in dmat, replaced with NA\n")
            dmat[dmat==Inf] <- NA
        }
        dfile <- paste(basefile, ".dist", sep="")
        write(t(dmat), file = dfile, ncolumns = ncol(dmat))
        on.exit(unlink(dfile), add=T)
    }

    ### Edges ###
    if (!missing(edges))
    {
        # check data type
        if (!is.matrix(edges) || !is.numeric(edges) || dim(edges)[2] != 2) {
            cat("The `edges' argument must be a numeric 2-column matrix\n")
            return()
        }

        edgesfile <- paste(basefile, ".edges", sep="")
        if(!access(edgesfile)) unlink(edgesfile)
        if (nrow(edges) > 0) {
            for (i in 1:nrow(edges))
                cat(edges[i,], "\n", file = edgesfile, append=T)
        }
        on.exit(unlink(edgesfile), add=T)
    }

    ### position matrix ###
    if (!missing(pos)) {
        pos <- eval(pos)
        if (sum(abs(pos[!is.na(pos)])) == Inf > 0)
        {
            cat("xgvis can't handle Inf in pos; replaced with NA\n")
            pos[pos==Inf] <- NA
        }
        pfile <- paste(basefile, ".pos", sep="")
        write(t(pos), file = pfile, ncolumns = ncol(pos))
        on.exit(unlink(pfile), add = T)
    }

    ### Row labels ###
    if (!missing(rowlab))
        # check data type
        if (!is.vector(rowlab) || !is.character(rowlab)) {
            cat("The `rowlab' argument needs to be a character vector\n")
            return()
        }
    if (length(rowlab) > 0) {
        rowfile <- paste(basefile, ".row", sep="")
        cat(rowlab, file = rowfile, sep="\n")
        on.exit(unlink(rowfile), add = T)
    }

    ### Colors ###
    if (!missing(colors)) {
        # check data type
        if (!is.vector(colors) || !is.character(colors)) {
            cat("The `colors' argument needs to be a character vector\n")
            return()
        }
        colorfile <- paste(basefile, ".colors", sep="")
        cat(colors, file = colorfile, sep="\n")
        on.exit(unlink(colorfile), add = T)
    }

    ### Glyphs ###
    if (!missing(glyphs)) {
        # check data type
        if (!is.vector(glyphs) || !is.numeric(glyphs)) {
            cat("The `glyphs' argument needs to be a numeric vector\n")
            return()
        }
        glyphfile <- paste(basefile, ".glyphs", sep="")
        cat(glyphs, file = glyphfile, sep="\n")
        on.exit(unlink(glyphfile), add = T)
    }

    ### Erase ###
    if (!missing(erase)) {
        # check data type
        if (!is.vector(erase) || !is.numeric(erase)) {
            cat("The `erase' argument needs to be a numeric vector\n")
            return()
        }
        erasefile <- paste(basefile, ".erase", sep="")
        cat(erase, file = erasefile, sep="\n")
        on.exit(unlink(erasefile), add = T)
    }

    ### Connected lines ###
    if (!missing(lines)) {
        # check data type
        if (!is.matrix(lines) || !is.numeric(lines) || dim(lines)[2] != 2) {
            cat("The `lines' argument must be a numeric 2-column matrix\n")
            return()
        }

        linesfile <- paste(basefile, ".lines", sep="")
        if(!access(linesfile)) unlink(linesfile)
        if (nrow(lines) > 0) {
            for (i in 1:nrow(lines))
                cat(lines[i,], "\n", file = linesfile, append=T)
            on.exit(unlink(linesfile), add = T)
        }
    }

    ### Line colors ###
    if ((!missing(lines) || !missing(edges)) && !missing(linecolors)) {
        # check data type
        if (!is.vector(linecolors) || !is.character(linecolors)) {
            cat("The `linecolors' argument must be a character vector\n")
            return()
        }
        linecolorfile <- paste(basefile, ".linecolors", sep="")
        cat(linecolors, file = linecolorfile, sep="\n")
        on.exit(unlink(linecolorfile), add = T)
    }

    ### Resources ###
    if (!missing(resources)) {
        # check data type
        if (!is.vector(resources) || !is.character(resources)) {
            cat("The `resources' argument must be a character vector\n")
            return()
        }
        resourcefile <- paste(basefile, ".resources", sep="")
        cat(resources, file = resourcefile, sep	="\n")
        on.exit(unlink(resourcefile), add = T)
    }


    # Note to installer:
    # Here you need to specify the path to the xgvis batch file/ executable
    # on your system.
    #
    xgvispath <- paste(xgobipath, "xgvis.bat", sep="/")
    command <- paste(xgvispath, basefile)
    cat(command, "\n")
    if(multi) {
        invisible(dos(command, multi = T, minimized = T,
                      output.to.S = F, translate = T))
        ## wait 5 seconds to allow xgvis to start and read its files.
        cat("waiting to allow xgvis to start...\n")
       .p <- proc.time()
        while(proc.time() < .p + 5) {}
    } else {
        invisible(dos(command, multi = F, minimized = T,
                      output.to.S = F, translate = T))
    }
}

knn1d <- function(train, test, cl)
{
  train <- as.matrix(train)
  if(is.null(dim(test))) dim(test) <- c(1, length(test))
  test <- as.matrix(test)
  p <- ncol(train)
  ntr <- nrow(train)
  if(length(cl) != ntr) stop("train and class have different lengths")
  nte <- nrow(test)
  if(ncol(test) != p) stop("Dims of test and train differ")
  clf <- as.factor(cl)
  nc <- max(unclass(clf))
  .C("VR_knn1",
     as.integer(ntr), as.integer(nte), as.integer(p), as.double(train),
     as.integer(unclass(clf)), as.double(test), res = integer(nte),
     integer(nc + 1), as.integer(nc), d = double(nte))$d
}
