library(SDM)
library(MASS)
library(nnet)

CVprobs <- function(fitfn, predfn, ...)
{
  res <- matrix(, 214, 6)
  for (i in sort(unique(rand))) {
     cat("fold ",i,"\n", sep="")
     learn <- fitfn(rand != i, ...)
     res[rand == i,] <- predfn(learn, rand==i)
  }
  res
}

probs.multinom <- CVprobs(
   function(x, ...) multinom(type ~ ., fgl[x,], ...),
   function(obj, x) predict(obj, fgl[x, ],type="probs"),
   maxit=1000, trace=F )

probs.yes <- as.vector(class.ind(fgl$type))
probs <- as.vector(probs.multinom)
par(pty="s")
plot(c(0,1), c(0,1), type="n", xlab="predicted probability",
   ylab="", xaxs="i", yaxs="i", las=1)
rug(probs[probs.yes==0], 0.02, side=1, lwd=0.5)
rug(probs[probs.yes==1], 0.02, side=3, lwd=0.5)
abline(0,1)
newp <- seq(0, 1, length=100)
lines(newp, predict(loess(probs.yes ~ probs, span=1), newp))
par(pty="m")

# This will give you two pages with the fit
# and the calibration plot

synth.cal <- function(skip=T, naver=1, ...)
{
  synth.set()
  fit <- nnet(yc ~ xs + ys, data=synth.tr, trace=F, skip=skip, ...)
  pred <- numeric(57*66)
  prf <- numeric(1000)
  XTest <- expand.grid(xs=seq(-1.24,1, 0.04), ys=seq(-0.2,1.1,0.02))
  for(iter in 1:naver) {
    cat(" ", iter, sep="")
	 pred <- pred + predict(fit, XTest)
    prf <- prf + drop(predict(fit, synth.te))
  }
  cat("\n")
  pred <- matrix(pred/naver, 57, 66)
  contour(seq(-1.24,1, 0.04), seq(-0.2,1.1,0.02),
    pred, add=T, levels=0.5, col=4)
  contour(seq(-1.24,1, 0.04), seq(-0.2,1.1,0.02),
    pred, add=T, levels=0.1, col=3)
  contour(seq(-1.24,1, 0.04), seq(-0.2,1.1,0.02),
    pred, add=T, levels=0.9, col=5)
  pr <- prf/naver
  err <- sum((pr > 0.5) != (synth.te$yc == 1))/10
  cat("\nError rate:", err,"%\n\n")
  par(pty="s")
  plot(c(0,1), c(0,1), type="n", xlab="predicted probability",
       ylab="", xaxs="i", yaxs="i", las=1)
  rug(pr[synth.te$yc==0], 0.02, side=1, lwd=0.5)
  rug(pr[synth.te$yc==1], 0.02, side=3, lwd=0.5)
  abline(0,1, col=2)
  newp <- seq(0, 1, length=100)
  lines(newp, predict(loess(synth.te$yc ~ pr, span=0.5), newp), col=6)
  invisible(par(pty="m"))

}

synth.cal(size=0) # logistic regression
synth.cal(size=6)
synth.cal(size=6, decay=0.01)
synth.cal(size=6, naver=25)
synth.cal(size=6, decay=0.001, naver=25)

synth.cal(size=6, decay=0.01, naver=25)
