.BG
.FN jackknife
.TL
 jackknife estimation
.CS
jackknife(x,theta,...)
 
.AG x
a vector containing the data. To jackknife  more complex data structures (e.g
bivariate data) see the last example below.
.AG theta
function to be jackknifed. Takes `x' as an argument, and
may take additional arguments (see below and last example).
.AG ...
any additional arguments to be passed to `theta'

 



.RT
list with the following components

.RC jack.se
The jackknife estimate of standard error of `theta'.
The leave-one out jackknife is used.
.RC jack.bias
The jackknife estimate of bias of `theta'.
The leave-one out jackknife is used.
.RC jack.values
The `n' leave-one-out values of `theta', 
where `n' is the number of observations.
That is, `theta' applied to `x' with
the 1st observation deleted, `theta' applied to `x' with
the 2nd observation deleted, etc.



.SH REFERENCES
Efron, B. and   Tibshirani, R. (1986).  The Bootstrap
method for standard errors, confidence intervals,
and other measures of statistical accuracy.
.ul
Statistical Science, 
Vol 1., No. 1, pp 1-35.
.PP
Efron, B. and Tibshirani, R. (1993) 
.ul
An Introduction to the Bootstrap.
Chapman and Hall, New York, London.
.EX
# jackknife values for the sample mean 
# (this is for illustration;  # since "mean" is  a 
#  built in function,  jackknife(x,mean) would be simpler!)

x <- rnorm(20)               
theta <- function(x){mean(x)}
                             
results <- jackknife(x,theta)        


# To jackknife functions of more  complex data structures, 
# write theta so that its argument x
#  is the set of observation numbers  
#  and simply  pass as data to jackknife the vector 1,2,..n. 
# For example, to jackknife
# the correlation coefficient from a set of 15 data pairs:      
                        
xdata <- matrix(rnorm(30),ncol=2)
n <- 15
theta <- function(x,xdata){ cor(xdata[x,1],xdata[x,2]) }
results <- jackknife(1:n,theta,xdata)



.KW jackknife
.WR
