.BG
.FN bootstrap
.TL
Non-parametric bootstrapping
.CS
bootstrap(x,nboot,theta,..., func=NULL)
 
.AG x
a vector containing the data. To bootstrap  more complex data structures (e.g
bivariate data) see the last example below.
.AG nboot
The number of bootstrap samples desired.
.AG theta
function to be bootstrapped. Takes `x' as an argument, and
may take additional arguments (see below and last example).
.AG ...
any additional arguments to be passed to theta
.AG func 
(optional) argument specifying the functional the distribution of thetahat that is desired.
If func is specified, the jackknife after-bootstrap estimate of its standard
error is also returned. See example below. 
 



.RT
list with the following components:

.RC thetastar
 the `nboot' bootstrap values of `theta'

.RC func.thetastar
 the functional `func' of the bootstrap distribution of thetastar, if `func' was specified

.RC jack.boot.val
the jackknife-after-bootstrap values for `func', if `func' was specified

.RC jack.boot.se
the jackknife-after-bootstrap standard error estimate of `func', if `func' was specified

 

.SH REFERENCES
Efron, B. and   Tibshirani, R. (1986).  The bootstrap
 method for standard errors, confidence intervals,
and other measures of   statistical accuracy.
.ul
Statistical Science, 
Vol 1., No. 1, pp 1-35.
.PP
Efron, B. (1992) Jackknife-after-bootstrap standard errors and influence functions.
.ul
J. Roy. Stat. Soc. B,
vol 54, pages 83-127
.PP
Efron, B. and Tibshirani, R. (1993) 
.ul
An Introduction to the Bootstrap.
Chapman and Hall, New York, London.


.EX

# 100 bootstraps of the sample mean 
# (this is for illustration;  since "mean" is  a 
# built in function, bootstrap(x,100,mean) would be simpler!)

x <- rnorm(20)                
theta <- function(x){mean(x)} 
                              
results <- bootstrap(x,100,theta)     
                             
# as above, but also estimate the 95th percentile   
# of the bootstrap dist'n of the mean, and         
# its jackknife-after-bootstrap  standard error    
                              
perc95 <- function(x){quantile(x, .95)}
                             
results <-  bootstrap(x,100,theta, func=perc95)                                   

# To bootstrap functions of more complex data structures, 
# write theta so that its argument x
#  is the set of observation numbers  
#  and simply  pass as data to bootstrap the vector 1,2,..n. 
# For example, to bootstrap
# the correlation coefficient from a set of 15 data pairs:

xdata <- matrix(rnorm(30),ncol=2)
n <- 15
theta <- function(x,xdata){ cor(xdata[x,1],xdata[x,2]) }
results <- bootstrap(1:n,20,theta,xdata)
.KW bootstrap
.WR
