.BG
.FN bootpred
.TL
bootstrap estimates of prediction error
.CS
bootpred(x,y,nboot,theta.fit,theta.predict,err.meas,...)
 
.AG x
a matrix containing the predictor (regressor) values. Each row
corresponds to an observation. 
.AG y
a vector containing the response values
.AG nboot
the number of bootstrap replications
.AG theta.fit
function to be cross-validated. Takes `x' and `y' as an argument.
See example below.
.AG theta.predict
function producing predicted values for `theta.fit'.
Arguments are a matrix `x' of predictors and fit object produced by `theta.fit'.
See example below.
.AG err.meas
function specifying error measure for a single response y and prediction yhat
 - see examples below
.AG ...
any additional arguments to be passed to theta.fit
.RT
list with the following components
.RC app.err
the apparent error rate- that is, the mean value of err.meas when `theta.fit'
is applied to x and y, and then used to predict y.
.RC optim
the bootstrap estimate of optimism in `app.err'. A useful
estimate of prediction error is `app.err+optim'
.RC err.632
the ".632" bootstrap estimate of prediction error.


.SH REFERENCES

Efron, B. (1983). Estimating the error rate of a prediction rule: improvements
on cross-validation. 
.ul
J. Amer. Stat. Assoc,
vol 78. pages 316-31.
.PP
Efron, B. and Tibshirani, R. (1993) 
.ul
An Introduction to the Bootstrap.
Chapman and Hall, New York, London.

.EX

# bootstrap prediction error estimation in least squares
#  regression


x <- rnorm(85)  
y <- 2*x +.5*rnorm(85)                      
theta.fit <- function(x,y){lsfit(x,y)}
theta.predict <- function(fit,x){
               cbind(1,x)%*%fit$coef         
               }    
sq.err_function(y,yhat) { (y-yhat)^2}                   
results <- bootpred(x,y,20,theta.fit,theta.predict,
     err.meas=sq.err)  
                                      

# for a classification problem, a standard choice 
# for err.meas would simply count up the
#  classification errors:

miss.clas <- function(y,yhat){ 1*(yhat!=y)}

# with this specification,  bootpred estimates 
#  misclassification rate



.KW bootstrap
.WR
