.BG
.FN bcanon
.TL
Nonparametric BCa confidence limits
.CS
bcanon(x, nboot, theta, ..., 
  alpha=c(0.025, 0.05, 0.1, 0.16, 0.84, 0.9, 0.95, 0.975))
.AG x
a vector containing the data. To bootstrap  more complex data structures (e.g
bivariate data) see the last example below.
.AG nboot
number of bootstrap replications
.AG theta
function defining the estimator used in constructing the confidence points
.AG ...
additional arguments for `theta'
.AG alpha
optional argument specifying confidence levels desired
.RT
list with the following components
.RC confpoint
estimated bca confidence limits
.RC z0
estimated bias correction
.RC acc
estimated acceleration constant
.RC u
jackknife influence values

.SH REFERENCES
Efron, B. and   Tibshirani, R. (1986).  The Bootstrap
method for standard errors, confidence intervals,
and other measures of   statistical accuracy.
.ul
Statistical Science,
Vol 1., No. 1, pp 1-35.
.PP
Efron, B. (1987). Better bootstrap confidence intervals (with discussion).
.ul
J. Amer. Stat. Assoc. 
vol 82, pg 171
.PP
Efron, B. and Tibshirani, R. (1993) 
.ul
An Introduction to the Bootstrap.
Chapman and Hall, New York, London.
.EX
#  bca limits for the  mean 
#  (this is for illustration; 
#   since "mean" is a built in function,
#   bcanon(x,100,mean) would be simpler!)

x <- rnorm(20)                
theta <- function(x){mean(x)}
results <- bcanon(x,100,theta)   
                              



# To obtain bca limits for functions of more 
# complex data structures, write theta
# so that its argument x is the set of observation
# numbers and simply pass as data to bcanon 
# the vector 1,2,..n. 
# For example, find bca limits for
# the correlation coefficient from a set of 15 data pairs:

xdata <- matrix(rnorm(30),ncol=2)
n <- 15
theta <- function(x,xdata){ cor(xdata[x,1],xdata[x,2]) }
results <- bcanon(1:n,100,theta,xdata)






.KW bootstrap
.WR
