.BG
.FN abcpar
.TL
Parametric  ABC  confidence limits 
.CS
abcpar(x, tt, S, etahat, mu, n=rep(1,length(x)),lambda=0.001, 
 alpha=c(0.025, 0.05, 0.1, 0.16))

.AG x
vector of data
.AG tt
function of expectation parameter `mu' defining the parameter of interest
.AG S
maximum likelihood estimate of the  covariance matrix of `x'
.AG etahat
maximum likelihood estimate of the natural parameter eta
.AG mu
function giving expectation of `x' in terms of eta
.AG n
optional argument containing denominators for binomial (vector of length `length(x)')
.AG lambda
optional argument specifying step size for finite difference calculation
.AG alpha
optional argument specifying confidence levels desired
.RT
list with the following components
.RC call
the call to `abcpar'
.RC limits
The nominal confidence level, ABC point, quadratic ABC point, and standard (normal) point.
.RC stats
list consisting of  observed value of `tt', estimated standard error and estimated bias
.RC constants
list consisting of `a'=acceleration constant, `z0'=bias adjustment, `cq'=curvature component



.SH REFERENCES

Efron, B, and DiCiccio, T. (1992) More accurate confidence intervals 
in exponential families. 
.ul
Biometrika
\fB79\fR, pages 231-245.
.PP
Efron, B. and Tibshirani, R. (1993) 
.ul
An Introduction to the Bootstrap.
Chapman and Hall, New York, London.
.EX
# binomial
# x is a p-vector of successes, n is a p-vector of 
#  number of trials
S <- matrix(0,nrow=p,ncol=p)
S[row(S)==col(S)] <- x*(1-x/n)
mu <- function(eta,n){n/(1+exp(eta))}
etahat <- log(x/(n-x))
#suppose p=2 and we are interested in mu2-mu1
tt <- function(mu){mu[2]-mu[1]}
x <- c(2,4); n <- c(12,12)
a <- abcpar(x, tt, S, etahat,n)




.KW bootstrap
.WR
