.BG
.FN abcnon
.TL
Nonparametric ABC confidence limits
.CS
abcnon(x, tt, epsilon=0.001, 
 alpha=c(0.025, 0.05, 0.1, 0.16, 0.84, 0.9, 0.95, 0.975))
.AG x
the data. Must be either a vector, or a matrix whose rows are the observations
.AG tt
function defining the parameter in the resampling form `tt(p,x)', where `p' is the
vector of proportions and `x' is the data
.AG epsilon
optional argument specifying step size for finite difference calculations
.AG alpha
optional argument specifying confidence levels desired
.RT
list with following components

.RC limits
The estimated confidence points, from the ABC and standard normal methods
.RC stats
list consisting of `t0'=observed value of `tt', `sighat'=infinitesimal jackknife estimate
 of standard error of `tt', `bhat'= estimated bias
.RC constants
list consisting of `a'=acceleration constant, `z0'=bias adjustment, `cq'=curvature component
.RC tt.inf
(approximate) influence components of `tt'
.RC pp
matrix whose rows are the resampling points in the least favourable family .
The abc confidence points are the function `tt' evaluated at these points

.SH REFERENCES
Efron, B, and DiCiccio, T. (1992) More accurate confidence intervals 
in exponential families. 
.ul
Biometrika
\fB79\fR, pages 231-245.
.PP
Efron, B. and Tibshirani, R. (1993) 
.ul
An Introduction to the Bootstrap.
Chapman and Hall, New York, London.
.EX
# compute abc intervals for the mean

x <- rnorm(10)
theta <- function(p,x) {sum(p*x)/sum(p)}
results <- abcnon(x, theta)  


# compute abc intervals for the correlation

x <- matrix(rnorm(20),ncol=2)
theta <- function(p, x)
{
	x1m <- sum(p * x[, 1])/sum(p)
	x2m <- sum(p * x[, 2])/sum(p)
	num <- sum(p * (x[, 1] - x1m) * (x[, 2] - x2m))
	den <- sqrt(sum(p * (x[, 2] - x1m)^2) *
              sum(p * (x[, 2] - x1m)^2))
	return(num/den)
}

results <- abcnon(x, theta)   


.KW  bootstrap
.WR
