\name{yags}
\alias{yags}
\alias{trylib}
\alias{tryset}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Yet Another GEE Solver}
\description{
Solves GEEs in an extensible way, with a C++ engine.
$Header: /udd/stvjc/VCROOT/yags/man/yags.Rd,v 1.3 2004/10/22 18:49:24 stvjc Exp $
}
\usage{
yags(formula, id, cor.met=NULL, family=gaussian, corstruct="independence", 
    control=yags.control(), weights=NULL, betainit=NULL, alphainit=NULL, 
    data=list(), subset=NULL)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{formula}{ GLM formula }
  \item{id}{ numeric vector of cluster discriminators; data assumed
sorted by this vector }
  \item{cor.met}{ correlation metameter: vector of observation
times for longitudinal data, matrix of coordinates
for other designs.  If unstructured working correlation,
this must have nonnegative integer values with zero origin. }
  \item{family}{ GLM family }
  \item{corstruct}{ string describing working correlation model.
For Wang and Carey 2004 JASA article structure, use "UQ.fom" }
  \item{control}{ list of control parameters, see yags.control() }
  \item{weights}{ vector of weights }
  \item{betainit}{ initial value of regression parameters }
  \item{alphainit}{ initial value of working correlation model parameters }
  \item{data}{ data source for model fit }
  \item{subset}{ expression selecting a subset for fitting }
}

\value{
see \code{\link{yags.object}}
}
\references{ Liang KY, Zeger SL.  Biometrika 1986 }
\author{ VJ Carey, stvjc@gauss.med.harvard.edu }

\seealso{ \code{\link{glm}} }

\examples{
#
# trivial demo
#
library(methods)
data(stackloss)
Y1 <- yags(stack.loss~Air.Flow,id=1:21, data=stackloss)
#
# spruce examples for gaussian family and various corstructs
#
data(Spruce)
SPRind <- yags(y~Time+treated,id=Subject,data=Spruce)
SPRexc <- yags(y~Time+treated,id=Subject,data=Spruce,
		corstr="exchangeable", alphainit=0.)
# unstructured:
SPRuns <- yags(y~Time+treated,id=Subject,data=Spruce,
		corstr="unstructured", alphainit=rep(.1,45),
                cor.met=as.double(rep(0:9,79)))
# U_J of Wang and Carey JASA 2004
SPRUJ <- yags(y~Time+treated,id=Subject,data=Spruce,
		corstr="UJ.fom", alphainit=.1,
                cor.met=as.double(rep(0:9,79)))
}

\keyword{ models }
\keyword{ multivariate }

