options(contrasts = c("contr.treatment", "contr.poly"))
options(na.action = "na.omit")
options(width=65, echo=TRUE, digits=5, length=9999)

library(survnnet)
library(survival)
data(capacitor)
data(lung)
#scale datasets
mycap <- capacitor
mycap$voltage <- (mycap$voltage-min(mycap$voltage,na.rm=TRUE))/
  (range(mycap$voltage,na.rm=TRUE)[2]-range(mycap$voltage,na.rm=TRUE)[1])

mylung <- apply(lung[,4:10],2,function(x)(x-min(x,na.rm=TRUE))/
		(range(x,na.rm=TRUE)[2]-range(x,na.rm=TRUE)[1]))
mylung <- cbind(lung[,1:3],mylung)
mylung$status <- mylung$status-1

set.seed(100)
#parametric models
#linear
llog <- survnnet(Surv(days,event) ~ voltage, data=mycap, size = 0,
                 trace = TRUE, skip = TRUE, model = "llog", alpha =0.1)
lnorm <- survnnet(Surv(days,event) ~ voltage, data=mycap, size = 0,
                  trace = TRUE, skip = TRUE, model = "lnorm", alpha =0.1)
wei <- survnnet(Surv(days,event) ~ voltage, data=mycap, size = 0,
                trace = TRUE, skip = TRUE, model = "weibull", alpha =0.1)
expl <- survnnet(Surv(days,event) ~ voltage, data=mycap, size = 0,
                 trace = TRUE, skip = TRUE, model = "exp")
survreg(Surv(days,event) ~ voltage, data=mycap, dist="logistic")
llog$wts
survreg(Surv(days,event) ~ voltage, data=mycap, dist="gaussian")
lnorm$wts
survreg(Surv(days,event) ~ voltage, data=mycap, dist="extreme")
wei$wts
survreg(Surv(days,event) ~ voltage, data=mycap, dist="exp")
expl$wts
llog <- survnnet(Surv(days,event) ~ voltage, data=mycap, decay = 0.01,
                size = 2, trace = TRUE, skip = TRUE, model = "llog",
                alpha = 0.1)
lnorm <- survnnet(Surv(days,event) ~ voltage, data=mycap, decay = 0.01,
                size = 2, trace = TRUE, skip = TRUE, model = "lnorm",
                alpha = 0.1)
wei <- survnnet(Surv(days,event) ~ voltage, data=mycap, decay = 0.01,
                size = 2, trace = TRUE, skip = TRUE, model = "weibull",
                alpha = 0.1)
expl <- survnnet(Surv(days,event) ~ voltage, data=mycap, decay = 0.01,
                size = 2, trace = TRUE, skip = TRUE, model = "exp")
bin <- survnnet(event ~ voltage,data=mycap,entropy=TRUE,skip=TRUE,size=0)
glm(event ~ voltage, data=mycap, family="binomial")
bin$wts
bin <- survnnet(event ~ voltage, data=mycap, entropy=TRUE, skip=TRUE, size=2,
                decay=0.01, trace=TRUE, maxit=500)
phfit <- phnnet(Surv(time,status)  ~ ., data=mylung[,-1], decay = 0.0,
                size = 0, skip=TRUE, trace = TRUE)
coxph(Surv(time,status)  ~ ., data=mylung[,-1])
phfit$wts
phtfit <-  phtnnet(Surv(time,status)   ~ ., data=mylung[,-1], decay = 0.0,
		   size = 0, skip=TRUE, trace = TRUE,
                   breakpts=c(0,10000), dohess=TRUE)
phtfit$wts
phtfit <-  phtnnet(Surv(time,status)   ~ ., data=mylung[,-1], decay = 0.01,
		   size = 2, skip=T, trace = T,maxit=1000,dohess=TRUE,
		   breakpts=c(0,100,200,300,10000))
