\name{survnnet}
\alias{survnnet}
\alias{survnnet.formula}
\alias{survnnet.default}
\alias{add.survnet}
\alias{norm.survnet}
\alias{eval.survnn}
\alias{coef.survnnet}
\alias{print.survnnet}
\alias{print.summary.survnnet}
\alias{summary.survnnet}
\title{
Fit Survival Neural Networks
}
\description{
Fit neural network models for survival data.
}
\usage{
survnnet.formula(formula, data = NULL, weights, \dots,
                subset, na.action = na.fail, contrasts = NULL)
survnnet.default(x, y, weights, size, Wts, mask = rep(1, length(wts)),
                linout = FALSE, entropy = FALSE, softmax = FALSE,
                censored = FALSE, skip = FALSE, rang = 0.7, decay = 0,
                bias.decay = 1, maxit = 100, Hess = FALSE, 
                trace = TRUE, MaxNWts = 1000, model = NULL,
                alpha = NULL, Nintervals = 20, varWt = 10)
}
\arguments{
\item{formula}{
A formula of the form \code{Response ~ x1 + x2 + \dots}. 
For parametric survival models must be  Surv(Time, Event) or equivalent.
}
\item{x}{
matrix or data frame of \code{x} values for examples.
}
\item{y}{
matrix or data frame of target values for examples.  For parametric survival 
networks, this must be the survival time followed by the censoring indicator 
(0 for censored, 1 for event).
}
\item{weights}{
(case) weights for each example -- if missing defaults to 1.
}
\item{size}{
number of units in the hidden layer. Can be zero if there are skip-layer units.
}
\item{data}{
Data frame from which variables specified in  \code{formula} are
preferentially to be taken.
}
\item{subset}{
An index vector specifying the cases to be used in the training
sample.  (NOTE: If given, this argument must be named.)
}
\item{na.action}{
A function to specify the action to be taken if \code{NA}s are found.
The default action is for the procedure to fail.  An alternative is
na.omit, which leads to rejection of cases with missing values on
any required variable.  (NOTE: If given, this argument must be named.)
}
\item{contrasts}{
a list of contrasts to be used for some or all of
the factors appearing as variables in the model formula.
}
\item{Wts}{
initial parameter vector. If missing chosen at random.
}
\item{mask}{
vector used to indicate which weights should be varied.
}
\item{linout}{
switch for linear output units. Default logistic output units. 
For parametric survival models will be set to linear automatically.
}
\item{entropy}{
switch for entropy (= maximum conditional likelihood) fitting. 
Set automatically for parametric survival models. 
 Otherwise default is least-squares.
}
\item{softmax}{
switch for softmax (log-linear model) and maximum conditional
likelihood fitting. \code{linout}, \code{entropy}, \code{softmax} and \code{censored} are mutually
exclusive.  Set automatically for parametric survival models.
}
\item{censored}{
A variant on \code{softmax}, in which non-zero targets mean possible
classes. Thus for \code{softmax} a row of \code{(0, 1, 1)} means one example
each of classes 2 and 3, but for \code{censored} it means one example whose
class is only known to be 2 or 3. Not used for parametric survival models.
}
\item{skip}{
switch to add skip-layer connections from input to output.
}
\item{rang}{
Initial random weights on \code{[-rang, rang]}.  Value about 0.5 unless the 
inputs are large, in which case it should be chosen so that 
\code{rang * max(|x|)} is about 1.
}
\item{decay}{
parameter for weight decay.  Default 0.  Can be a single number or a vector 
the same length as the weights vector.
}
\item{bias.decay}{
parameter to allow scaling of the weight decay for bias units.  Defaults to 1
which has no effect.  Decay for any weights from the bias units will be divided
by this value.
}
\item{maxit}{
maximum number of iterations. Default 100.
}
\item{Hess}{
If true, the Hessian of the measure of fit at the best set of weights
found is returned as component \code{Hessian}.
}
\item{trace}{
switch for tracing optimization. Default \code{True}.
}
\item{MaxNWts}{
The maximum allowable number of weights.  There is no intrinsic limit
in the code, but increasing \code{MaxNWts} will probably allow fits that
are very slow and time-consuming (and perhaps uninterruptable under Windows).
}
\item{model}{
Name of parametric model to be used, if any: one of  \code{"exp"},
\code{"weibull"}, \code{"llog"}, \code{"lnorm"}, \code{"lnormvar"} or \code{"hazard"}. 
}
\item{alpha}{
For parametric survival models only, starting value for the shape parameter. 
Not used for the exponential model or the hazard model.}
\item{Nintervals}{
For hazard models only, number of intervals to use in the integration.}
\item{varWt}{
For log normal models with varying variance only, number to divide the
second output by for the variance. High values reduce the variability of
the variance.}
\item{\dots}{further arguments passed to the default method.}
}
\value{
object of class \code{"survnnet.formula"} or \code{"survnnet"}  with components

\item{wts}{
the best set of weights found
}
\item{value}{
value of fitting criterion plus weight decay term.
}
\item{fitted.values}{
the fitted values for the training data.
}
\item{alpha}{
  for parametric survival fits, the final value of the shape parameter
}}
\details{
Fits various feed-forward neural nets. 
Discrete time survival models can be fitted using the entropy, 
softmax and censored options. Parametric survival nets fit 
survival distributions (options are exponential, Weibull,
log-logistic and log-normal).   Based on nnet,
which may be faster for softmax, entropy and sum of squares
fitting.  For proportional hazard models see \code{phnnet}.


If the response in \code{formula} is a factor, an appropriate
classification network is constructed; this has one output and entropy
fit if the number of levels is two, and a number of outputs equal to
the number of classes and a softmax output stage for more levels.  If
the response is not a factor, it is passed on unchanged to
\code{nnet.default}.  For parametric survival models the response in
\code{formula} must be a Surv object (or equivalent).


Some of the formulae for the survival likelihoods are difficult to
evaluate with large values of the data, so it is important to scale
the data sufficiently.  Nets with no hidden units should find weights
equal to the coefficents in the equivalent \code{survreg} fit, (but with
opposite signs): this can be used as a check on the scaling.


A quasi-Newton optimizer is used, written in \code{C}.
}
\references{
R. M. Ripley (2004) "\code{survnnet}: Neural network survival models:
Version 1.1." 
Part of documentation of this package.
}
\seealso{
  \code{\link{predict.survnnet}}, \code{\link{survnnet.Hess}},
  \code{\link[nnet]{nnet}}, \code{\link{phnnet}},
  \code{\link[survival]{survreg}}
}
\examples{
data(capacitor)
mycap <- capacitor
mycap$voltage <- (mycap$voltage-min(mycap$voltage,na.rm=TRUE))/
  (range(mycap$voltage,na.rm=TRUE)[2]-range(mycap$voltage,na.rm=TRUE)[1])


wei <- survnnet(Surv(days,event) ~ voltage, data=mycap,decay = 0.01,
                size = 2, trace = TRUE, skip = TRUE, model = 'weibull', 
                alpha = 0.1, maxit=100)
}
\keyword{neural}
% Converted by Sd2Rd version 1.21.
