\name{survnnet.Hess}
\alias{survnnet.Hess}
\title{
Evaluates Hessian for a Survival Neural Network
}
\description{
Evaluates the Hessian (matrix of second derivatives) of the specified
neural network. Normally called via argument \code{Hess=T} to \code{survnnet}.
}
\usage{
survnnet.Hess(net, x, y, weights)
}
\arguments{
\item{net}{
object of class \code{survnnet} as returned by \code{survnnet}.
}
\item{x}{
training data.  Must be in the form of a \code{model.matrix} output.
}
\item{y}{
classes for training data. 
}
\item{weights}{
the (case) weights used in the \code{survnnet} fit.
}}
\value{
square symmetric matrix of the Hessian evaluated at the weights stored 
in the net.
}
\seealso{
\code{\link{survnnet}}, \code{\link{predict.survnnet}}
}
\examples{
data(capacitor)
mycap <- capacitor
mycap$voltage <- (mycap$voltage-min(mycap$voltage,na.rm=TRUE))/
  (range(mycap$voltage,na.rm=TRUE)[2]-range(mycap$voltage,na.rm=TRUE)[1])


wei <- survnnet(Surv(days,event) ~ voltage, data=mycap,decay = 0.01,
                size = 2, trace = TRUE, skip = TRUE, model = 'weibull', 
                alpha =0.1,maxit=100)


eigen(survnnet.Hess(wei, mycap[,3],mycap[,1:2]), TRUE)$values
}
\keyword{neural}
% Converted by Sd2Rd version 1.21.
