\name{predict.survnnet}
\alias{predict.survnnet}
\alias{predict.survnnet.formula}
\title{
Predict New Examples by a Survival Neural Net
}
\description{
Predict new examples by a trained survival neural net.
}
\usage{
predict.survnnet(object, x, type = c("raw", "class"), loglike = FALSE,
stime = NULL, allHaz = FALSE, \dots)
}
\arguments{
\item{object}{
an object of class \code{survnnet} as  returned by \code{survnnet}.
}
\item{x}{
matrix or data frame of test examples. A vector is considered to be
a row vector comprising a single case.}
\item{type}{select raw output from the net, or the most probable class for a
  net with a factor response.}
\item{loglike}{for \code{model=hazard} only, return the cumulative
  hazard part of the log likelihood contribution (useful in cross-validation)}
\item{stime}{for \code{model=hazard} only, the survival time for the prediction}
\item{allHaz}{for \code{model=hazard} only, return predictions at
  object\$Nintervals from 0 to stime}
\item{\dots}{arguments passed from or to other methods.}
}
\value{
The values returned by the trained network. For \code{model=hazard} a list
of three items is returned if either \code{loglike} or \code{allHaz} is set to
True. The first item contains the predicted values at \code{stime}, the second
contains the log likelihood contributions, and the third contains the
predictions of the hazard function at Nintervals points from 0 to
\code{stime}. For \code{model="lnormvar"}, two columns are returned, the
second of which is the (unscaled) log variance. 
}
\details{
This function is a method for the generic function
\code{predict()} for class \code{"survnnet"}.
It can be invoked by calling \code{predict(x)} for an
object \code{x} of the appropriate class, or directly by
calling \code{predict.survnnet(x)} regardless of the
class of the object.
}
\seealso{
\code{\link{survnnet}}
}
\examples{
data(capacitor)
mycap <- capacitor
mycap$voltage <- (mycap$voltage-min(mycap$voltage,na.rm=TRUE))/
  (range(mycap$voltage,na.rm=TRUE)[2]-range(mycap$voltage,na.rm=TRUE)[1])


wei <- survnnet(Surv(days,event) ~ voltage, data=mycap,decay = 0.01,
                size = 2, trace = TRUE, skip = TRUE, model = 'weibull', 
                alpha = 0.1, maxit=100)
preds <- predict(wei,mycap)
}
\keyword{neural}
% Converted by Sd2Rd version 1.21.
