\name{predict.phtnnet}
\alias{predict.phtnnet}
\alias{predict.phtnnet.formula}
\title{
Predict New Examples by a Time-varying Neural Net
}
\description{
Predict new examples by a trained time-varying neural net.
}
\usage{
predict.phtnnet(object, x, ...)
}
\arguments{
\item{object}{
an object of class \code{phtnnet} as  returned by \code{phtnnet}.
}
\item{x}{
matrix or data frame of test examples. A vector is considered to be a
row vector comprising a single case.  The time zone variable need not
be included but if included will cause no problems. It is not
used as predictions will be returned for each time zone.}
\item{\dots}{arguments passed from or to other methods.}
}
\value{
Matrix of scores returned by the trained network.  (One for each time zone)
}
\details{
This function is a method for the generic function
\code{predict()} for class \code{"phtnnet"}.
It can be invoked by calling \code{predict(x)} for an
object \code{x} of the appropriate class, or directly by
calling \code{predict.phtnnet(x)} regardless of the
class of the object.
}
\seealso{
\code{\link{phtnnet}}
}
\examples{
library(survival)
data(lung)
mylung <- apply(lung[,4:10],2,function(x)(x-min(x,na.rm=TRUE))/
		(range(x,na.rm=TRUE)[2]-range(x,na.rm=TRUE)[1])) 
mylung <- cbind(lung[,1:3],mylung) 
mylung$status <- mylung$status-1    


            
phtfit <-  phtnnet(Surv(time,status)   ~ ., data=mylung[,-1], decay = 0.01, 
		   size = 2, skip=TRUE, trace = TRUE,maxit=1000,dohess=TRUE,
		   breakpts=c(0,100,200,300,10000))
preds <- predict(phtfit,mylung)
}
\keyword{neural}
% Converted by Sd2Rd version 1.21.
