\name{predict.phnnet}
\alias{predict.phnnet}
\alias{predict.phnnet.formula}
\title{
Predict New Examples by a Proportional Hazards Net
}
\description{
Predict new examples by a trained proportional hazards neural net.
}
\usage{
predict.phnnet(object, x, ...)
}
\arguments{
\item{object}{
an object of class \code{phnnet} as  returned by \code{phnnet}.
}
\item{x}{
matrix or data frame of test examples. A vector is considered to be
a row vector comprising a single case.}
\item{\dots}{arguments passed from or to other methods.}
}
\value{
The scores returned by the trained network.
}
\details{
This function is a method for the generic function
\code{predict()} for class \code{"phnnet"}.
It can be invoked by calling \code{predict(x)} for an
object \code{x} of the appropriate class, or directly by
calling \code{predict.phnnet(x)} regardless of the
class of the object.
}
\seealso{
\code{\link{phnnet}}
}
\examples{
library(survival)
data(lung)
mylung <- apply(lung[,4:10],2,function(x)(x-min(x,na.rm=TRUE))/
		(range(x,na.rm=TRUE)[2]-range(x,na.rm=TRUE)[1])) 
mylung <- cbind(lung[,1:3],mylung) 
mylung$status <- mylung$status-1                


phfit <-  phnnet(Surv(time,status)  ~ ., data=mylung[,-1], decay = 0.01,
size = 2, skip=TRUE, trace = TRUE, maxit = 1000,  bias.decay=25)
preds <- predict(phfit,mylung)
}
\keyword{neural}
% Converted by Sd2Rd version 1.21.
