\name{phtnnet}
\alias{phtnnet}
\alias{phtnnet.formula}
\alias{phtnnet.default}
\title{
Fit Time-Varying Survival Models
}
\description{
Fits a time-varying survival model using the output of a neural net
}
\usage{
phtnnet.formula(formula, data=NULL, \dots,
               subset, na.action=na.fail, contrasts=NULL)
phtnnet.default(x, status, size,  Wts, mask, skip=FALSE, rang=0.7, 
               decay=0, bias.decay=1, breakpts, MaxNWts=1000,
               maxit=100, trace=TRUE, dohaz=FALSE, dohess=FALSE)
}
\arguments{
\item{formula}{
A formula of the form \code{ Response ~ x1 + x2 + \dots}.  See details below
for required form.
}
\item{x}{
matrix or data frame of \code{x} values for examples.  
See details below for treatment of the time zone variable.
}
\item{status}{
Survival time and censoring indicator.  See details below for options.
}
\item{size}{
number of units in the hidden layer. Can be zero if there are skip-layer units.
}
\item{data}{
Data frame from which variables specified in  \code{formula} are
preferentially to be taken.
}
\item{subset}{
An index vector specifying the cases to be used in the training
sample.  (NOTE: If given, this argument must be named.)
}
\item{na.action}{
A function to specify the action to be taken if \code{NA}s are found.
The default action is for the procedure to fail.  An alternative is
\code{na.omit}, which leads to rejection of cases with missing values on
any required variable.  (NOTE: If given, this argument must be named.)
}
\item{contrasts}{
a list of contrasts to be used for some or all  of
the  factors  appearing as variables in the model formula.
}
\item{Wts}{
initial parameter vector. If missing chosen at random.
}
\item{mask}{
vector used to indicate which weights should be varied.
}
\item{skip}{
switch to add skip-layer connections from input to output.
}
\item{rang}{
Initial random weights on \code{[-rang, rang]}.  Value about 0.5 unless the 
inputs are large, in which case it should be chosen so that 
\code{rang * max(|x|)} is about 1.  See details below for note on scaling of data.
}
\item{decay}{
parameter for weight decay.  Default 0.  May be a single value to be used for 
all weights, or a vector 
the same length as the weights vector.
}
\item{bias.decay}{
factor by which to divide the weight decay for weights from the bias unit. 
(Easy way to use two values of weight decay only).
}
\item{breakpts}{
Break points to use on the survival time to create time zones.  If present,
the \code{Response} or \code{status} must contain the survival time, and
\code{breakpts} must cover all the data.
}
\item{MaxNWts}{
The maximum allowable number of weights.  There is no intrinsic limit
in the code, but increasing \code{MaxNWts} will probably allow fits that are
very slow and time-consuming (and perhaps uninterruptable under
Windows).
}
\item{maxit}{
maximum number of iterations. Default 100.
}
\item{trace}{
switch for tracing optimization. Default \code{True}.
}
\item{dohaz}{
If true, the cumulative hazard function estimated at the best set of weights
is returned as component \code{haz}.
}
\item{dohess}{
If true, the Hessian of the measure of fit at the best set of weights
found is returned as component \code{hess}.}
\item{\dots}{further arguments passed to the default method.}
}
\value{
Object of class \code{"phtnnet.formula"} or \code{"phtnnet"} (inherits from \code{"phnnet"}), 
with components

\item{wts}{
the best set of weights found
}
\item{value}{
value of fitting criterion plus weight decay term.
}
\item{fitted.values}{
the fitted values for the training data.  This will have a score for each 
time zone for each example.
}}
\details{
A neural network is used to fit a function of the covariates in a
time-varying model. The model essentially allows the ratios of a
proportional hazards model to vary smoothly over time.  The code is
based on nnet, but with significant changes since the partial
likelihood is not a sum over examples. Note that case weights are not
currently available.


The time zone for each example may be specified in one of two ways:
using the \code{breakpts} argument or using the final column of the data
matrix, which should then contain appropriately scaled zone values.
(N.B. care must be taken that the use of a formula does not alter the
order of your variables.)  To use the \code{breakpts} argument, the
survival times must be supplied using \code{Surv(time,event)} (or equivalent)
as the \code{status} argument or as the \code{Response} in the formula.  The
survival times must also be supplied if the data are not sorted in
decreasing order of survival time.  When \code{breakpts} is used, the time
zones will be scaled to lie in the interval [0,1].


There is no bias on the output layer: the total number of weights
includes this one, but it is not used.


A quasi-Newton optimizer is used, written in \code{C}.
}
\references{
Ripley R. M. (2004) "\code{survnnet}: Neural network survival models:
Version 1.1." Part of
documentation of this package.
}
\seealso{
\code{\link{predict.phtnnet}}, \code{\link{phtnnet.Hess}}, \code{\link{phnnet}},  \code{\link[nnet]{nnet}}
}
\examples{
library(survival)
data(lung)
mylung <- apply(lung[,4:10],2,function(x)(x-min(x,na.rm=TRUE))/
		(range(x,na.rm=TRUE)[2]-range(x,na.rm=TRUE)[1])) 
mylung <- cbind(lung[,1:3],mylung) 
mylung$status <- mylung$status-1    
            
phtfit <-  phtnnet(Surv(time,status)   ~ ., data=mylung[,-1], decay = 0.01, 
		   size = 2, skip=TRUE, trace = TRUE,maxit=1000,dohess=TRUE,
		   breakpts=c(0,100,200,300,10000))
}
\keyword{neural}
% Converted by Sd2Rd version 1.21.
